/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Collections;
import javax.resource.ResourceException;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;

public class ThreadLocalCachingConnectionInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final ThreadLocal connections = new ThreadLocal();
    private final boolean matchConnections;

    public ThreadLocalCachingConnectionInterceptor(ConnectionInterceptor next, boolean matchConnections) {
        this.next = next;
        this.matchConnections = matchConnections;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        if (connectionInfo.isUnshareable()) {
            this.next.getConnection(connectionInfo);
            return;
        }
        ManagedConnectionInfo managedConnectionInfo = (ManagedConnectionInfo)this.connections.get();
        if (managedConnectionInfo != null) {
            if (this.matchConnections) {
                ManagedConnectionInfo mciRequest = connectionInfo.getManagedConnectionInfo();
                if (null != managedConnectionInfo.getManagedConnectionFactory().matchManagedConnections(Collections.singleton(managedConnectionInfo.getManagedConnection()), mciRequest.getSubject(), mciRequest.getConnectionRequestInfo())) {
                    connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
                    return;
                }
                this.connections.set(null);
                this.next.returnConnection(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
            } else {
                connectionInfo.setManagedConnectionInfo(managedConnectionInfo);
                return;
            }
        }
        this.next.getConnection(connectionInfo);
        this.connections.set(connectionInfo.getManagedConnectionInfo());
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        if (connectionReturnAction == ConnectionReturnAction.DESTROY || connectionInfo.isUnshareable()) {
            this.next.returnConnection(connectionInfo, connectionReturnAction);
        }
    }

    public void destroy() {
        this.next.destroy();
    }
}

