/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.util.Properties;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;

public class SocketConnectionFactory
implements ConnectionFactory {
    public void init(Properties props) {
    }

    public Connection getConnection(URI uri) throws IOException {
        SocketConnection conn = new SocketConnection();
        conn.open(uri);
        return conn;
    }

    class SocketConnection
    implements Connection {
        Socket socket = null;
        OutputStream socketOut = null;
        InputStream socketIn = null;

        SocketConnection() {
        }

        protected void open(URI uri) throws IOException {
            try {
                this.socket = new Socket(uri.getHost(), uri.getPort());
                this.socket.setTcpNoDelay(true);
            }
            catch (ConnectException e) {
                throw new ConnectException("Cannot connect to server '" + uri.toString() + "'.  Check that the server is started and that the specified serverURL is correct.");
            }
            catch (IOException e) {
                throw new IOException("Cannot connect to server: '" + uri.toString() + "'.  Exception: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (SecurityException e) {
                throw new IOException("Cannot access server: '" + uri.toString() + "' due to security restrictions in the current VM: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot  connect to server: '" + uri.toString() + "' due to an unkown exception in the OpenEJB client: " + e.getClass().getName() + " : " + e.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                if (this.socketOut != null) {
                    this.socketOut.close();
                }
                if (this.socketIn != null) {
                    this.socketIn.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Throwable t) {
                throw new IOException("Error closing connection with server: " + t.getMessage());
            }
        }

        public InputStream getInputStream() throws IOException {
            try {
                this.socketIn = this.socket.getInputStream();
            }
            catch (StreamCorruptedException e) {
                throw new IOException("Cannot open input stream to server, the stream has been corrupted: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (IOException e) {
                throw new IOException("Cannot open input stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            return this.socketIn;
        }

        public OutputStream getOuputStream() throws IOException {
            try {
                this.socketOut = this.socket.getOutputStream();
            }
            catch (IOException e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            return this.socketOut;
        }
    }
}

