/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.DataSourceMetaData;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.InjectionMetaData;
import org.apache.openejb.client.Response;

public class JNDIResponse
implements Response {
    private transient int responseCode = -1;
    private transient Object result;

    public JNDIResponse() {
    }

    public JNDIResponse(int code, Object obj) {
        this.responseCode = code;
        this.result = obj;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.responseCode = in.readByte();
        switch (this.responseCode) {
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                this.result = in.readObject();
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 13: {
                EJBMetaDataImpl m = new EJBMetaDataImpl();
                m.readExternal(in);
                this.result = m;
                break;
            }
            case 22: {
                DataSourceMetaData ds = new DataSourceMetaData();
                ds.readExternal(in);
                this.result = ds;
                break;
            }
            case 23: {
                InjectionMetaData imd = new InjectionMetaData();
                imd.readExternal(in);
                this.result = imd;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte((byte)this.responseCode);
        switch (this.responseCode) {
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                out.writeObject(this.result);
                break;
            }
            case 14: 
            case 16: {
                break;
            }
            case 13: {
                EJBMetaDataImpl m = (EJBMetaDataImpl)this.result;
                m.writeExternal(out);
                break;
            }
            case 22: {
                DataSourceMetaData ds = (DataSourceMetaData)this.result;
                ds.writeExternal(out);
                break;
            }
            case 23: {
                InjectionMetaData imd = (InjectionMetaData)this.result;
                imd.writeExternal(out);
            }
        }
    }
}

