/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.Request;

public class JNDIRequest
implements Request {
    private transient int requestMethod = -1;
    private transient String requestString;
    private transient String moduleId;

    public JNDIRequest() {
    }

    public JNDIRequest(int requestMethod, String requestString) {
        this.requestMethod = requestMethod;
        this.requestString = requestString;
    }

    public byte getRequestType() {
        return 1;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestString() {
        return this.requestString;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setRequestMethod(int requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setRequestString(String requestString) {
        this.requestString = requestString;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.requestMethod = in.readByte();
        this.requestString = in.readUTF();
        this.moduleId = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte((byte)this.requestMethod);
        out.writeUTF(this.requestString);
        out.writeObject(this.moduleId);
    }
}

