/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.AuthenticationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import javax.sql.DataSource;
import org.apache.openejb.client.AuthenticationRequest;
import org.apache.openejb.client.AuthenticationResponse;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClientDataSource;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.DataSourceMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.JNDIRequest;
import org.apache.openejb.client.JNDIResponse;
import org.apache.openejb.client.ServerMetaData;
import org.omg.CORBA.ORB;

public class JNDIContext
implements Serializable,
InitialContextFactory,
Context {
    private transient String tail = "/";
    private transient ServerMetaData server;
    private transient ClientMetaData client;
    private transient Hashtable env;
    private String moduleId;

    JNDIContext(Hashtable environment) throws NamingException {
        this.init(environment);
    }

    public JNDIContext() {
    }

    public JNDIContext(JNDIContext that) {
        this.tail = that.tail;
        this.server = that.server;
        this.client = that.client;
        this.moduleId = that.moduleId;
        this.env = (Hashtable)that.env.clone();
    }

    public void init(Hashtable environment) throws NamingException {
    }

    private JNDIResponse request(JNDIRequest req) throws Exception {
        return (JNDIResponse)Client.request(req, new JNDIResponse(), this.server);
    }

    public static void print(String s) {
    }

    public static void println(String s) {
    }

    protected AuthenticationResponse requestAuthorization(AuthenticationRequest req) throws RemoteException {
        return (AuthenticationResponse)Client.request(req, new AuthenticationResponse(), this.server);
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        URI location;
        String psswrd;
        String userID;
        block8: {
            if (environment == null) {
                throw new NamingException("Invalid Argument, hashtable cannot be null.");
            }
            this.env = (Hashtable)environment.clone();
            userID = (String)this.env.get("java.naming.security.principal");
            psswrd = (String)this.env.get("java.naming.security.credentials");
            Object serverURI = this.env.get("java.naming.provider.url");
            this.moduleId = (String)this.env.get("openejb.client.moduleId");
            if (serverURI == null) {
                serverURI = "foo://localhost:4201";
            }
            String uriString = (String)serverURI;
            location = null;
            try {
                location = new URI(uriString);
            }
            catch (Exception e) {
                if (uriString.indexOf("://") != -1) break block8;
                try {
                    location = new URI("foo://" + uriString);
                }
                catch (URISyntaxException giveUp) {
                    throw (ConfigurationException)new ConfigurationException("Context property value error for java.naming.provider.url :" + e.getMessage()).initCause(e);
                }
            }
        }
        this.server = new ServerMetaData(location);
        if (userID != null) {
            this.authenticate(userID, psswrd);
        } else {
            this.client = new ClientMetaData();
        }
        return this;
    }

    public void authenticate(String userID, String psswrd) throws AuthenticationException {
        AuthenticationRequest req = new AuthenticationRequest(userID, psswrd);
        AuthenticationResponse res = null;
        try {
            res = this.requestAuthorization(req);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getLocalizedMessage());
        }
        switch (res.getResponseCode()) {
            case 1: {
                this.client = res.getIdentity();
                break;
            }
            case 2: {
                this.client = res.getIdentity();
                this.server = res.getServer();
                break;
            }
            case 3: {
                throw new AuthenticationException("This principle is not authorized.");
            }
        }
    }

    public EJBHomeProxy createEJBHomeProxy(EJBMetaDataImpl ejbData) {
        EJBHomeHandler handler = EJBHomeHandler.createEJBHomeHandler(ejbData, this.server, this.client);
        EJBHomeProxy proxy = handler.createEJBHomeProxy();
        handler.ejb.ejbHomeProxy = proxy;
        return proxy;
    }

    private Object createBusinessObject(Object result) {
        Object[] data = (Object[])result;
        EJBMetaDataImpl ejb = (EJBMetaDataImpl)data[0];
        Object primaryKey = data[1];
        EJBObjectHandler handler = EJBObjectHandler.createEJBObjectHandler(ejb, this.server, this.client, primaryKey);
        return handler.createEJBObjectProxy();
    }

    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("The name cannot be null");
        }
        if (name.equals("")) {
            return new JNDIContext(this);
        }
        if (name.startsWith("java:")) {
            name = name.replaceFirst("^java:", "");
        } else if (!name.startsWith("/")) {
            name = this.tail + name;
        }
        String prop = name.replaceFirst("comp/env/", "");
        String value = System.getProperty(prop);
        if (value != null) {
            return this.parseEntry(prop, value);
        }
        if (name.equals("comp/ORB")) {
            return this.getDefaultOrb();
        }
        JNDIRequest req = new JNDIRequest();
        req.setRequestMethod(27);
        req.setRequestString(name);
        req.setModuleId(this.moduleId);
        JNDIResponse res = null;
        try {
            res = this.request(req);
        }
        catch (Exception e) {
            if (e instanceof RemoteException && e.getCause() instanceof ConnectException) {
                e = (Exception)e.getCause();
                throw (ServiceUnavailableException)new ServiceUnavailableException("Cannot lookup '" + name + "'.").initCause(e);
            }
            throw (NamingException)new NamingException("Cannot lookup '" + name + "'.").initCause(e);
        }
        switch (res.getResponseCode()) {
            case 13: {
                return this.createEJBHomeProxy((EJBMetaDataImpl)res.getResult());
            }
            case 21: {
                return this.createBusinessObject(res.getResult());
            }
            case 12: {
                return res.getResult();
            }
            case 23: {
                return res.getResult();
            }
            case 14: {
                JNDIContext subCtx = new JNDIContext(this);
                if (!name.endsWith("/")) {
                    name = name + '/';
                }
                subCtx.tail = name;
                return subCtx;
            }
            case 22: {
                return this.createDataSource((DataSourceMetaData)res.getResult());
            }
            case 24: {
                String type = (String)res.getResult();
                value = System.getProperty("Resource/" + type);
                if (value == null) {
                    return null;
                }
                return this.parseEntry(prop, value);
            }
            case 16: {
                throw new NameNotFoundException(name + " does not exist in the system.  Check that the app was successfully deployed.");
            }
            case 17: {
                throw (NamingException)res.getResult();
            }
            case 18: {
                throw (RuntimeException)res.getResult();
            }
            case 19: {
                throw (Error)res.getResult();
            }
        }
        throw new RuntimeException("Invalid response from server :" + res.getResponseCode());
    }

    private Object parseEntry(String name, String value) throws NamingException {
        try {
            URI uri = new URI(value);
            String scheme = uri.getScheme();
            if (scheme.equals("link")) {
                value = System.getProperty(uri.getSchemeSpecificPart());
                if (value == null) {
                    return null;
                }
                return this.parseEntry(name, value);
            }
            if (scheme.equals("datasource")) {
                uri = new URI(uri.getSchemeSpecificPart());
                String driver = uri.getScheme();
                String url = uri.getSchemeSpecificPart();
                return new ClientDataSource(driver, url, null, null);
            }
            if (scheme.equals("connectionfactory")) {
                uri = new URI(uri.getSchemeSpecificPart());
                String driver = uri.getScheme();
                String url = uri.getSchemeSpecificPart();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    this.getClass().getClassLoader();
                }
                if (classLoader == null) {
                    ClassLoader.getSystemClassLoader();
                }
                try {
                    Class<?> clazz = Class.forName(driver, true, classLoader);
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object connectionFactory = constructor.newInstance(url);
                    return connectionFactory;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot use ConnectionFactory in client VM without the classh: " + driver, e);
                }
            }
            if (scheme.equals("javamail")) {
                return Session.getDefaultInstance((Properties)new Properties());
            }
            if (scheme.equals("orb")) {
                return this.getDefaultOrb();
            }
            throw new UnsupportedOperationException("Unsupported Naming URI scheme '" + scheme + "'");
        }
        catch (URISyntaxException e) {
            throw (NamingException)new NamingException("Unparsable jndi entry '" + name + "=" + value + "'.  Exception: " + e.getMessage()).initCause(e);
        }
    }

    private DataSource createDataSource(DataSourceMetaData dataSourceMetaData) {
        return new ClientDataSource(dataSourceMetaData);
    }

    private ORB getDefaultOrb() {
        return ORB.init();
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this.env.put(key, value);
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        return this.env.remove(key);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.env.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }
}

