/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import org.apache.openejb.client.EJBHomeProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBMetaDataImpl
implements EJBMetaData,
Externalizable {
    public static final byte STATEFUL = 6;
    public static final byte STATELESS = 7;
    public static final byte BMP_ENTITY = 8;
    public static final byte CMP_ENTITY = 9;
    protected transient byte type;
    protected transient String deploymentID;
    protected transient int deploymentCode;
    protected transient Class homeClass;
    protected transient Class remoteClass;
    protected final transient List<Class> businessClasses = new ArrayList<Class>();
    protected transient Class keyClass;
    protected transient EJBHome ejbHomeProxy;

    public EJBMetaDataImpl() {
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, String typeOfBean, List<Class> businessInterfaces) {
        if ("STATEFUL".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)6;
        } else if ("STATELESS".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)7;
        } else if ("BMP_ENTITY".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)8;
        } else if ("CMP_ENTITY".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)9;
        }
        this.homeClass = homeInterface;
        this.remoteClass = remoteInterface;
        if (businessInterfaces != null) {
            this.businessClasses.addAll(businessInterfaces);
        }
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, String typeOfBean, List<Class> businessInterfaces) {
        this(homeInterface, remoteInterface, typeOfBean, businessInterfaces);
        if (this.type == 9 || this.type == 8) {
            this.keyClass = primaryKeyClass;
        }
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, String typeOfBean, String deploymentID, List<Class> businessInterfaces) {
        this(homeInterface, remoteInterface, primaryKeyClass, typeOfBean, businessInterfaces);
        this.deploymentID = deploymentID;
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, String typeOfBean, String deploymentID, int deploymentCode, List<Class> businessInterfaces) {
        this(homeInterface, remoteInterface, primaryKeyClass, typeOfBean, deploymentID, businessInterfaces);
        this.deploymentCode = deploymentCode;
    }

    public Class getPrimaryKeyClass() {
        if (this.type != 8 && this.type != 9) {
            throw new UnsupportedOperationException();
        }
        return this.keyClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeProxy;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public boolean isStatelessSession() {
        return this.type == 7;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public boolean isSession() {
        return this.type == 6 || this.type == 7;
    }

    protected void setEJBHomeProxy(EJBHomeProxy home) {
        this.ejbHomeProxy = home;
    }

    public String getDeploymentID() {
        return this.deploymentID;
    }

    public Class getHomeClass() {
        return this.homeClass;
    }

    public List<Class> getBusinessClasses() {
        return this.businessClasses;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.homeClass);
        out.writeObject(this.remoteClass);
        out.writeObject(this.keyClass);
        out.writeObject(this.ejbHomeProxy);
        out.writeByte(this.type);
        out.writeUTF(this.deploymentID);
        out.writeShort((short)this.deploymentCode);
        out.writeShort((short)this.businessClasses.size());
        for (Class clazz : this.businessClasses) {
            out.writeObject(clazz);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.homeClass = (Class)in.readObject();
        this.remoteClass = (Class)in.readObject();
        this.keyClass = (Class)in.readObject();
        this.ejbHomeProxy = (EJBHome)in.readObject();
        this.type = in.readByte();
        this.deploymentID = in.readUTF();
        this.deploymentCode = in.readShort();
        for (int i = in.readShort(); i > 0; --i) {
            this.businessClasses.add((Class)in.readObject());
        }
    }
}

