/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Request;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.ServerMetaData;

public class Client {
    private static final Logger logger = Logger.getLogger("OpenEJB.client");
    private static final ProtocolMetaData PROTOCOL_VERSION = new ProtocolMetaData("3.0");
    private static Client client = new Client();

    public static void setClient(Client client) {
        Client.client = client;
    }

    public static Response request(Request req, Response res, ServerMetaData server) throws RemoteException {
        return client.processRequest(req, res, server);
    }

    protected Response processRequest(Request req, Response res, ServerMetaData server) throws RemoteException {
        if (server == null) {
            throw new IllegalArgumentException("Server instance cannot be null");
        }
        OutputStream out = null;
        ObjectOutputStream objectOut = null;
        EjbObjectInputStream objectIn = null;
        Connection conn = null;
        try {
            URI[] uris = server.getLocations();
            for (int i = 0; i < uris.length; ++i) {
                URI uri = uris[i];
                try {
                    conn = ConnectionManager.getConnection(uri);
                    continue;
                }
                catch (IOException e) {
                    if (uris.length == 1) {
                        throw new RemoteException("Cannot connect to server '" + uri + '\"', e);
                    }
                    logger.log(Level.WARNING, "Cannot connect to server(s): " + uri.getHost() + ":" + uri.getPort() + " Exception: ", e);
                    continue;
                }
                catch (Throwable e) {
                    throw new RemoteException("Cannot connect to server: " + uri.getHost() + ":" + uri.getPort() + " due to an unkown exception in the OpenEJB client: ", e);
                }
            }
            if (conn == null) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < uris.length; ++i) {
                    URI uri = uris[i];
                    buffer.append((i != 0 ? ", " : "") + "Server #" + i + ": " + uri);
                }
                throw new RemoteException("Cannot connect to any servers: " + buffer.toString());
            }
            try {
                out = conn.getOuputStream();
            }
            catch (IOException e) {
                throw new RemoteException("Cannot open output stream to server: ", e);
            }
            catch (Throwable e) {
                throw new RemoteException("Cannot open output stream to server: ", e);
            }
            try {
                PROTOCOL_VERSION.writeExternal(out);
            }
            catch (Throwable e) {
                throw new RemoteException("Cannot write the protocol metadata to the server: ", e);
            }
            try {
                out.write(req.getRequestType());
            }
            catch (IOException e) {
                throw new RemoteException("Cannot write the request type to the server: ", e);
            }
            catch (Throwable e) {
                throw new RemoteException("Cannot write the request type to the server: ", e);
            }
            try {
                objectOut = new ObjectOutputStream(out);
            }
            catch (IOException e) {
                throw new RemoteException("Cannot open object output stream to server: ", e);
            }
            catch (Throwable e) {
                throw new RemoteException("Cannot open object output stream to server: ", e);
            }
            try {
                req.writeExternal(objectOut);
                objectOut.flush();
            }
            catch (NotSerializableException e) {
                throw new IllegalArgumentException("Object is not serializable: " + e.getMessage());
            }
            catch (IOException e) {
                throw new RemoteException("Cannot write the request to the server: ", e);
            }
            catch (Throwable e) {
                throw new RemoteException("Cannot write the request to the server: ", e);
            }
            InputStream in = null;
            try {
                in = conn.getInputStream();
            }
            catch (IOException e) {
                throw new RemoteException("Cannot open input stream to server: ", e);
            }
            ProtocolMetaData protocolMetaData = null;
            try {
                protocolMetaData = new ProtocolMetaData();
                protocolMetaData.readExternal(in);
            }
            catch (IOException e) {
                throw new RemoteException("Cannot deternmine server protocol version: Received " + protocolMetaData.getSpec(), e);
            }
            try {
                objectIn = new EjbObjectInputStream(in);
            }
            catch (Throwable e) {
                throw new RemoteException("Cannot open object input stream to server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
            }
            try {
                res.readExternal(objectIn);
            }
            catch (ClassNotFoundException e) {
                throw new RemoteException("Cannot read the response from the server.  The class for an object being returned is not located in this system:", e);
            }
            catch (IOException e) {
                throw new RemoteException("Cannot read the response from the server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new RemoteException("Error reading response from server (" + protocolMetaData.getSpec() + ") : " + e.getMessage(), e);
            }
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Throwable error) {
            throw new RemoteException("Error while communicating with server: ", error);
        }
        finally {
            try {
                conn.close();
            }
            catch (Throwable t) {
                System.out.println("Error closing connection with server: " + t.getMessage());
            }
        }
        return res;
    }
}

