/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.scriptapi;

import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.pnuts.scriptapi.PnutsScriptEngine;
import pnuts.lang.Pnuts;

public class PnutsScriptEngineFactory
implements ScriptEngineFactory {
    @Override
    public List<String> getExtensions() {
        return Arrays.asList("pnut");
    }

    @Override
    public List<String> getMimeTypes() {
        return Arrays.asList(new String[0]);
    }

    @Override
    public List<String> getNames() {
        return Arrays.asList("pnuts");
    }

    @Override
    public String getEngineName() {
        return "Pnuts";
    }

    @Override
    public String getEngineVersion() {
        return PnutsScriptEngine.class.getPackage().getSpecificationVersion();
    }

    @Override
    public String getLanguageVersion() {
        return Pnuts.class.getPackage().getSpecificationVersion();
    }

    @Override
    public String getLanguageName() {
        return "Pnuts";
    }

    @Override
    public Object getParameter(String s) {
        if (s.equals("javax.script.name")) {
            return this.getEngineVersion();
        }
        if (s.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (s.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (s.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (s.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (s.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new PnutsScriptEngine();
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(obj);
        sbuf.append(".");
        sbuf.append(m);
        sbuf.append("(");
        int len = args.length;
        sbuf.append(args[0]);
        for (int i = 1; i < len; ++i) {
            sbuf.append(",");
            sbuf.append(args[i]);
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("println(\"");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    sbuf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    sbuf.append("\\\\");
                    continue block4;
                }
                default: {
                    sbuf.append(ch);
                }
            }
        }
        sbuf.append("\")");
        return sbuf.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sbuf = new StringBuilder();
        for (int i = 0; i < statements.length; ++i) {
            sbuf.append(statements[i]);
            sbuf.append("\n");
        }
        return sbuf.toString();
    }
}

