/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.scriptapi;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.pnuts.scriptapi.BindingsPackage;
import org.pnuts.scriptapi.PnutsBindings;
import org.pnuts.scriptapi.PnutsScriptEngine;
import pnuts.lang.Context;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;

public class PnutsScriptContext
implements ScriptContext {
    private Reader reader;
    protected Context context;
    Bindings globalBindings;
    PnutsBindings engineBindings;
    BindingsPackage bindingsPackage;

    public PnutsScriptContext() {
        this(new Context(), new PnutsBindings(), new PnutsBindings());
        this.initializeContext(this.context);
    }

    public PnutsScriptContext(Bindings engineBindings, Bindings globalBindings) {
        this(new Context(), engineBindings, globalBindings);
        this.initializeContext(this.context);
    }

    public PnutsScriptContext(ScriptContext scriptContext) {
        this(new Context(), scriptContext.getBindings(100), scriptContext.getBindings(200));
        this.initializeContext(this.context);
    }

    protected void initializeContext(Context context) {
        ArrayList modules = PnutsScriptEngine.startupModules;
        if (modules != null) {
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                context.usePackage((String)it.next());
            }
        }
    }

    public PnutsScriptContext(Context context, Bindings engineBindings, Bindings globalBindings) {
        this.context = context;
        this.reader = new InputStreamReader(System.in);
        this.engineBindings = engineBindings instanceof PnutsBindings ? (PnutsBindings)engineBindings : new PnutsBindings(engineBindings);
        this.globalBindings = globalBindings;
        this.bindingsPackage = new BindingsPackage();
        if (globalBindings != null) {
            this.bindingsPackage.setBindings(globalBindings, 200);
        }
        if (engineBindings != null) {
            this.bindingsPackage.setBindings(engineBindings, 100);
        }
        context.setCurrentPackage((Package)this.bindingsPackage);
    }

    public Context getPnutsContext() {
        return this.context;
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        if (scope == 200) {
            this.globalBindings = bindings;
        } else if (scope == 100) {
            if (bindings instanceof PnutsBindings) {
                this.engineBindings = (PnutsBindings)bindings;
            } else if (bindings != null) {
                this.engineBindings = new PnutsBindings(bindings);
            }
        } else {
            throw new IllegalArgumentException("Illegal scope value.");
        }
        if (bindings != null) {
            this.bindingsPackage.setBindings(bindings, scope);
            this.context.setCurrentPackage((Package)this.bindingsPackage);
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        if (scope == 200) {
            return this.globalBindings;
        }
        if (scope == 100) {
            return this.engineBindings;
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public void setAttribute(String attr, Object value, int scope) {
        this.getBindings(scope).put(attr, value);
    }

    @Override
    public Object getAttribute(String attr, int scope) {
        return this.getBindings(scope).get(attr);
    }

    @Override
    public Object removeAttribute(String attr, int scope) {
        return this.getBindings(scope).remove(attr);
    }

    @Override
    public Object getAttribute(String name) {
        String symbol = name.intern();
        Bindings ns = this.getBindings(100);
        if (ns instanceof PnutsBindings) {
            NamedValue binding = ((PnutsBindings)ns).lookup(symbol);
            if (binding != null) {
                return binding.get();
            }
        } else if (ns.containsKey(symbol)) {
            return ns.get(symbol);
        }
        ns = this.getBindings(200);
        return ns.get(symbol);
    }

    @Override
    public int getAttributesScope(String name) {
        Bindings ns = this.getBindings(100);
        if (ns.containsKey(name)) {
            return 100;
        }
        ns = this.getBindings(200);
        if (ns.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.context.getWriter();
    }

    @Override
    public Writer getErrorWriter() {
        return this.context.getErrorWriter();
    }

    @Override
    public void setWriter(Writer writer) {
        this.context.setWriter(writer);
    }

    @Override
    public void setErrorWriter(Writer w) {
        this.context.setErrorWriter(w);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return Arrays.asList(100, 200);
    }
}

