/* $Id: LineView.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

/**
 * ܂Ot񋟂B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class LineView extends JComponent
{
	/** g */
	static private final Border border = BorderFactory.createEtchedBorder();

	/** \f */
	private LineViewModel model;

	/**
	 * ܂Ot𐶐B
	 *
	 * @param model \f
	 */
	public LineView(LineViewModel model)
	{
		if (model == null) throw new IllegalArgumentException("View model not found.");
		this.model = model;
	}
	
	/**
	 * \fԂB
	 *
	 * @return \f
	 */
	public LineViewModel getModel()
	{
		return model;
	}

	/**
	 * \GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Dimension size = this.getSize();
		int w = size.width;
		int h = size.height;

		//wi̕`
		g.setColor(getBackground());
		g.fillRect(0, 0, w, h);

		//r̕`
		paintGrid(g, w, h);

		//Ot̕`
		paintGraph(g, w, h);
		
		//Og̕`
		border.paintBorder(this, g, 0, 0, w, h);

		g.dispose();
	}
	
	/**
	 * Obh`悷
	 *
	 * @param g `ΏۃOtBbNX
	 * @param w `敝
	 * @param h `捂
	 */
	private void paintGrid(Graphics g, int w, int h)
	{
		int maxCount = model.getMaxCount();
		int maxColumn = model.getMaxColumn();

		g.setColor(getForeground());
		
		//c`悷
		int gridW = (int)(((float)w) / ((float)maxColumn));
		for (int i = 0; i <= w; i += gridW)
			g.drawLine(i, 0, i, h);

		//`悷
		int baseH = getGridBase(maxCount);
		float rateH = ((float)baseH) / ((float)maxCount);
		if (rateH > 0.5f) rateH /= 5f;
		int gridH = (int)(((float)h) * rateH);
		for (int i = h; i >= 0; i -= gridH)
			g.drawLine(0, i, w, i);
	}
	
	/**
	 * Ot`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 * @param w `敝
	 * @param h `捂
	 */
	private void paintGraph(Graphics g, int w, int h)
	{
		int catCount = model.getCategoryCount();
		int maxCount = model.getMaxCount();
		int maxColumn = model.getMaxColumn();
		int[] lineXData = new int[maxColumn];
		int[] lineYData = new int[maxColumn];
		int[] bgXData = new int[maxColumn + 2];
		int[] bgYData = new int[maxColumn + 2];

		int gridW = (int)(((float)w) / ((float)maxColumn));

		bgXData[0] = 0; bgYData[0] = h;
		bgXData[bgXData.length - 1] = w - gridW; bgYData[bgXData.length - 1] = h;
		
		for (int i = 0; i < maxColumn; i++) {
			int x = i * gridW;
			lineXData[i] = x;
			bgXData[i + 1] = x;
		}

		for (int i = 0; i < catCount; i++) {
			String category = model.getCategoryName(i);
			for (int j = 0; j < maxColumn; j++) {
				int val = model.getValue(category, j);
				float rate = ((float)val) / ((float)maxCount);
				int y = h - ((int)(((float)h) * rate));
				lineYData[j] = y;
				bgYData[j + 1] = y;
			}
			g.setColor(model.getBackground(category));
			g.fillPolygon(new Polygon(bgXData, bgYData, maxColumn + 2));
			g.setColor(model.getForegound(category));
			g.drawPolyline(lineXData, lineYData, maxColumn);
		}
	}
	
	/**
	 * \őlObhPʂ̊ԂB
	 *
	 * @param maxCount \ől
	 * @return ObhPʂ̊
	 */
	private int getGridBase(int maxCount)
	{
		int base = 1;
		int comp = 10;
		while (base < 10000000) {
			if (maxCount <= comp) return base;
			base = comp;
			comp *= 10;
		}
		return base;
	}
}
