/* $Id: BarView.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

/**
 * w肳ꂽʂ\o[[^񋟂
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class BarView extends JComponent
{
	/** I[o[t[wiF */
	static private final Color OVERFLOW_COLOR = Color.red;
	/** g */
	static private final Border border = BorderFactory.createEtchedBorder();

	/** o[g */
	private Border barBorder;

	/** \ől */
	private int maxCount = 10;
	/** \l */
	private int count = 0;
	
	/**
	 * o[\B
	 *
	 * @param bg wiF
	 * @param fg OiF
	 * @param max \ől
	 */
	public BarView(Color bg, Color fg, int max)
	{
		this.setBackground(bg);
		this.setForeground(fg);
		this.maxCount = max;
		barBorder = new BevelBorder(BevelBorder.RAISED, fg.brighter(), fg.darker());
	}

	/**
	 * \GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Dimension size = this.getSize();
		int w = size.width;
		int h = size.height;

		g.setColor(getBackground());
		g.fillRect(0, 0, w, h);
		Dimension psize = this.getPreferredSize();

		border.paintBorder(this, g, 0, 0, w, h);
		
		g.setColor(getForeground());
		float rate = ((float)count) / ((float)maxCount);
		if (rate > 1.0) {
			g.setColor(OVERFLOW_COLOR);
			rate = 1.0f;
		}
		int val = (int)(((float)w) * rate);
		if (val > 0) {
			g.fillRect(0, 1, val, h - 2);
			barBorder.paintBorder(this, g, 0, 1, val, h - 2);
		}

		g.dispose();
	}

	/**
	 * \lݒ肷B
	 * 
	 * @param count \l
	 */
	public void setCount(int count)
	{
		this.count = count;
		repaint();
	}

	/**
	 * \őlݒ肷B
	 * 
	 * @param maxCount \ől
	 */
	public void setMaxCount(int maxCount)
	{
		this.maxCount = maxCount;
		repaint();
	}
}
