/* $Id: NauticaQueueDAO.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * ���b�Z�[�W�L���[�ɑ΂���DAO
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class NauticaQueueDAO
{
	/** SQL */
	static private final String SELECT_QUEUE_COUNT =
		"select count(ID) from APP.ACTIVEMQ_MSGS where CONTAINER = ?";
	
	/**
	 * �w�肳�ꂽ�L���[�̓o�^����Ԃ��B
	 *
	 * @param conn JDBC�ڑ�
	 * @param category �L���[��
	 * @return �o�^��
	 * @throws SQLException �C�ӂ̗�O
	 */
	static public int getQueueCount(Connection conn, String category)
	throws SQLException
	{
		PreparedStatement st = conn.prepareStatement(SELECT_QUEUE_COUNT);
		try {
			st.setString(1, category);
			
			ResultSet rs = st.executeQuery();
			
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} finally {
			st.close();
		}
	}
}
