/* $Id: NumericDocument.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.common;

import javax.swing.text.*;

/**
 * l͗ptB[ĥ߂̐sB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class NumericDocument extends ByteLimitedDocument
{
	/** _܂܂Ă邩ǂ̃tO */
	private boolean hasPoint   = false;
	/** }CiX܂܂Ă邩ǂ̃tO */
	private boolean hasSign    = false;
	/** ͂𐳂̐Ɍ肷邩ǂ̃tOBtruȅꍇA0ȏ̓͂̂݋B */
	private boolean isPositive = false;
	/** ͂𐮐Ɍ肷邩ǂ̃tOBtruȅꍇA̓͂̂݋B */
	private boolean isInteger  = false;

	/**
	 * l͐phLgIuWFNg𐶐B
	 *
	 * @param limit ͐oCg
	 */
	public NumericDocument(int limit)
	{
		super(limit);
	}

	/**
	 * l͐phLgIuWFNg𐶐B
	 *
	 * @param limit     ͐oCg
	 * @param isInteger ͂𐮐Ɍ肷邩\tO
	 */
	public NumericDocument(int limit, boolean isInteger)
	{
		super(limit);
		this.isInteger = isInteger;
	}

	/**
	 * l͐phLgIuWFNg𐶐B
	 *
	 * @param limit      ͐oCg
	 * @param isInteger  ͂𐮐Ɍ肷邩\tO
	 * @param isPositive ͂𐳂̐Ɍ肷邩\tO
	 */
	public NumericDocument(int limit, boolean isInteger, boolean isPositive)
	{
		super(limit);
		this.isInteger = isInteger;
		this.isPositive = isPositive;
	}

	/**
	 * }̐sB
	 *
	 * @param offset }ʒu
	 * @param s      }
	 * @param a      l
	 * @throws BadLocationException w肳ꂽ}̈ʒuAhLg̗LȈʒuł͂Ȃꍇ
	 */
	public void insertString(int offset, String s, AttributeSet a) throws BadLocationException
	{
		if (s == null) return;

		char[] chars = s.toCharArray();
		int max = chars.length;
		boolean tempPoint = hasPoint;
		boolean tempSign = hasSign;

		for (int i = 0; i < max; i++) {
			char c = chars[i];
			switch (c) {
			case '.':
				if (isInteger) return;
				if (tempPoint) return;
				if (offset == 0) return;
				if (i != 0) return;
				char c2 = getText(0, 1).charAt(0);
				if (c2 == '-') {
					if (offset < 2) return;
				}
				tempPoint = true;
				break;
			case '-':
				if (isPositive) return;
				if (tempSign) return;
				if (offset != 0) return;
				tempSign = true;
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
				break;
			default:
				return;
			}
		}

		super.insertString(offset, s, a);

		hasPoint = tempPoint;
		hasSign = tempSign;
	}

	/**
	 * 폜̐sB
	 *
	 * @param offset 폜ʒu
	 * @param len    폜
	 * @throws BadLocationException w肳ꂽ폜̈ʒuAhLg̗LȈʒuł͂Ȃꍇ
	 */
	public void remove(int offset, int len) throws BadLocationException
	{
		boolean tempPoint = hasPoint;
		boolean tempSign = hasSign;

		String s = getText(offset, len);

		if (s.indexOf('.') > -1) tempPoint = false;
		if (s.indexOf('-') > -1) tempSign = false;

		super.remove(offset, len);

		hasPoint = tempPoint;
		hasSign = tempSign;
	}
}
