/* $Id: ByteLimitedDocument.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.common;

import javax.swing.text.*;

/**
 * oCg͗ptB[ĥ߂̐sBoCgSJISR[hɂČvZB
 * <br>JaváA{FEPgpē͂sƁAJavam̕ɂ炸A
 * L[͂̂тɂ}Ă̐폜JԂdlɂȂĂB
 * ɑΉɂ́AFEP̏Ԃm˂΂ȂȂAݗeՂȃC^tF[X͂ȂB
 * āA݂͌<u>AttributeSetnullȊO</u>̏ꍇAϊƂĎ舵
 * ͏̑ΏۂƂȂ̂ƂB̂߁AݓIȌ듮̉\͂邪A
 * eXg͈̔͂ł͂܂ĂBeXgɂ́AWin NT + IME 2000gpB
 * <i>(2001/12/19 nito)</i></br>
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class ByteLimitedDocument extends PlainDocument
{
	/** oCg */
	private int limit;

	/**
	 * ͐phLgIuWFNg𐶐B
	 *
	 * @param limit ͐oCg
	 */
	public ByteLimitedDocument(int limit)
	{
		this.limit = limit;
	}

	/**
	 * }̐sB
	 *
	 * @param offset }ʒu
	 * @param s      }
	 * @param a      l
	 * @throws BadLocationException w肳ꂽ}̈ʒuAhLg̗LȈʒuł͂Ȃꍇ
	 */
	public void insertString(int offset, String s, AttributeSet a) throws BadLocationException
	{
		if (s == null) return;

		String currentString = getText(0, getLength());
		byte[] currentBytes = null;
		byte[] insertBytes  = null;
		try {
			currentBytes = currentString.getBytes("SJIS");
			insertBytes  = s.getBytes("SJIS");
		} catch (Exception ex) {}

		//{̓VXeŕϊ̒l͐Am蕶݂̂B
		if (a == null) {
			if ((currentBytes.length + insertBytes.length) > limit) return;
		}

		super.insertString(offset, s, a);
	}
}
