/* $Id: QueueMonitorFrame.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.border.Border;

import jp.co.argo21.nautica.tool.qmon.common.NumericDocument;
import jp.co.argo21.nautica.tool.qmon.common.ResourceManager;
import jp.co.argo21.nautica.tool.qmon.dao.NauticaQueueDAO;
import jp.co.argo21.nautica.tool.qmon.swing.BarView;
import jp.co.argo21.nautica.tool.qmon.swing.LineView;
import jp.co.argo21.nautica.tool.qmon.swing.LineViewModel;

/**
 * QueueMonitor̃t[𐶐B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class QueueMonitorFrame extends JFrame
{
	/** wiF */
	static private final Color BG_COLOR            = Color.white;
	/** ObhF */
	static private final Color GRID_COLOR          = Color.lightGray;
	/** vZXJn҂F */
	static private final Color PROC_START_COLOR    = new Color(255, 102, 153);
	/** ANeBreBJn҂F */
	static private final Color ACT_START_COLOR     = new Color(255, 204,  51);
	/** ANeBreBI҂F */
	static private final Color ACT_END_COLOR       = new Color(102, 255,   0);
	/** vZXI҂F */
	static private final Color PROC_END_COLOR      = new Color( 51, 102, 204);
	/** vZXJn҂wiF */
	static private final Color PROC_START_BG_COLOR = new Color(255, 102, 153, 64);
	/** ANeBreBJn҂wiF */
	static private final Color ACT_START_BG_COLOR  = new Color(255, 204,  51, 64);
	/** ANeBreBI҂wiF */
	static private final Color ACT_END_BG_COLOR    = new Color(102, 255,   0, 64);
	/** vZXI҂wiF */
	static private final Color PROC_END_BG_COLOR   = new Color( 51, 102, 204, 64);

	/** XVpxx */
	static private String[] intervalNames;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();
	
	private JComboBox intervalBox;

	private JTextField maxField;
	private JTextField processStartField;
	private JTextField activityStartField;
	private JTextField activityEndField;
	private JTextField processEndField;

	private JLabel maxLabel;
	private JLabel minLabel;

	private BarView processStartBar;
	private BarView activityStartBar;
	private BarView activityEndBar;
	private BarView processEndBar;
	
	private LineView graphView;

	/** Ď^C}[ */
	private Timer timer;
	/** ݒ */
	private MonitorSetting setting; 

	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = QueueMonitor.getResourceManager();

		intervalNames = new String[4];
		intervalNames[0] = rm.getResource("QueueMonitorFrame.intervalName.0");
		intervalNames[1] = rm.getResource("QueueMonitorFrame.intervalName.1");
		intervalNames[2] = rm.getResource("QueueMonitorFrame.intervalName.2");
		intervalNames[3] = rm.getResource("QueueMonitorFrame.intervalName.3");
	}

	/**
	 * t[𐶐B
	 *
	 * @param setting ݒ
	 */
	public QueueMonitorFrame(MonitorSetting setting)
	{
		super();

		this.setting = setting;
		
		ResourceManager rm = QueueMonitor.getResourceManager();

		setTitle(rm.getResource("QueueMonitorFrame.title"));
		setResizable(false);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);

		Container contentPane = getContentPane();
		BorderLayout layout = new BorderLayout();
		contentPane.setLayout(layout);
		contentPane.add(createMonitorPanel(setting, rm), BorderLayout.CENTER);
		pack();

		//EBhE𒆉ɔzu
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Dimension screen = toolkit.getScreenSize();
		int sw = screen.width;
		int sh = screen.height;
		
		int fw = getWidth();
		int fh = getHeight();

		setLocation((sw - fw) / 2, (sh - fh) / 2);

		ActionListener listener = new MonitorListener();
		int interval = setting.getInterval();
		if (interval < 0) interval = MonitorSetting.INTERVAL_MIDDLE;

		timer = new Timer(interval, listener);
		timer.setRepeats(false);
		if (setting.getInterval() != MonitorSetting.INTERVAL_STOP) {
			timer.start();
		}
	}

	/**
	 * EBhECxg𐧌䂷B
	 *
	 * @param	e		WindowEvent
	 */
	protected void processWindowEvent(WindowEvent e)
	{
		super.processWindowEvent(e);

		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			System.exit(0);
		}
	}
	
	/**
	 * pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createMonitorPanel(MonitorSetting setting, ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(490, 400);
		panel.setSize(size);
		panel.setPreferredSize(size);

		JLabel l0 = new JLabel(rm.getResource("QueueMonitorFrame.label.0"));
		l0.setHorizontalAlignment(SwingConstants.RIGHT);
		JLabel l1 = new JLabel(rm.getResource("QueueMonitorFrame.label.1"));
		l1.setHorizontalAlignment(SwingConstants.RIGHT);
		JLabel l2 = new JLabel(rm.getResource("QueueMonitorFrame.label.2"));
		l2.setHorizontalAlignment(SwingConstants.RIGHT);
		JLabel l3 = new JLabel(rm.getResource("QueueMonitorFrame.label.3"));
		l3.setHorizontalAlignment(SwingConstants.RIGHT);
		JLabel l4 = new JLabel(rm.getResource("QueueMonitorFrame.label.4"));
		l4.setHorizontalAlignment(SwingConstants.RIGHT);
		JLabel l5 = new JLabel(rm.getResource("QueueMonitorFrame.label.5"));
		l5.setHorizontalAlignment(SwingConstants.RIGHT);

		processStartField = new JTextField("0");
		processStartField.setEditable(false);
		processStartField.setHorizontalAlignment(SwingConstants.RIGHT);

		activityStartField = new JTextField("0");
		activityStartField.setEditable(false);
		activityStartField.setHorizontalAlignment(SwingConstants.RIGHT);

		activityEndField = new JTextField("0");
		activityEndField.setEditable(false);
		activityEndField.setHorizontalAlignment(SwingConstants.RIGHT);

		processEndField = new JTextField("0");
		processEndField.setEditable(false);
		processEndField.setHorizontalAlignment(SwingConstants.RIGHT);

		intervalBox = new JComboBox(intervalNames);
		int interval = setting.getInterval();
		if (interval == MonitorSetting.INTERVAL_HIGH) intervalBox.setSelectedIndex(0);
		else if (interval == MonitorSetting.INTERVAL_LOW) intervalBox.setSelectedIndex(2);
		else intervalBox.setSelectedIndex(1);
		intervalBox.addItemListener(new IntervalListener());

		int maxCount = setting.getMaxCount();
		String maxStr = "" + maxCount;
		maxField = new JTextField();
		maxField.setHorizontalAlignment(SwingConstants.RIGHT);
		maxField.setDocument(new NumericDocument(8, true, true));
		maxField.addActionListener(new MaxCountListener());
		maxField.setText(maxStr);
		
		maxLabel = new JLabel(maxStr);
		maxLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		minLabel = new JLabel("0");
		minLabel.setHorizontalAlignment(SwingConstants.RIGHT);

		processStartBar = new BarView(BG_COLOR, PROC_START_COLOR, maxCount);
		activityStartBar = new BarView(BG_COLOR, ACT_START_COLOR, maxCount);
		activityEndBar = new BarView(BG_COLOR, ACT_END_COLOR, maxCount);
		processEndBar = new BarView(BG_COLOR, PROC_END_COLOR, maxCount);
		
		QueueMonitorViewModel model = new QueueMonitorViewModel(maxCount, 20);

		model.addCategory(
				QueueMonitor.START_PROCESS_REQUEST,
				PROC_START_COLOR,
				PROC_START_BG_COLOR);
		model.addCategory(
				QueueMonitor.START_ACTIVITY_REQUEST,
				ACT_START_COLOR,
				ACT_START_BG_COLOR);
		model.addCategory(
				QueueMonitor.END_ACTIVITY_REQUEST,
				ACT_END_COLOR,
				ACT_END_BG_COLOR);
		model.addCategory(
				QueueMonitor.END_PROCESS_REQUEST,
				PROC_END_COLOR,
				PROC_END_BG_COLOR);
		
		graphView = new LineView(model);
		graphView.setBackground(BG_COLOR);
		graphView.setForeground(GRID_COLOR);

		panel.add(locate(l0,                 110,  10,  90,  25));
		panel.add(locate(intervalBox,        210,  10, 100,  25));
		panel.add(locate(l1,                 310,  10,  90,  25));
		panel.add(locate(maxField,           410,  10,  70,  25));
		panel.add(locate(l2,                  10,  40, 180,  25));
		panel.add(locate(processStartBar,    200,  40, 200,  25));
		panel.add(locate(processStartField,  410,  40,  70,  25));
		panel.add(locate(l3,                  10,  70, 180,  25));
		panel.add(locate(activityStartBar,   200,  70, 200,  25));
		panel.add(locate(activityStartField, 410,  70,  70,  25));
		panel.add(locate(l4,                  10, 100, 180,  25));
		panel.add(locate(activityEndBar,     200, 100, 200,  25));
		panel.add(locate(activityEndField,   410, 100,  70,  25));
		panel.add(locate(l5,                  10, 130, 180,  25));
		panel.add(locate(processEndBar,      200, 130, 200,  25));
		panel.add(locate(processEndField,    410, 130,  70,  25));
		panel.add(locate(maxLabel,            10, 160,  65,  25));
		panel.add(locate(minLabel,            10, 360,  65,  25));
		panel.add(locate(graphView,           80, 175, 400, 200));

		validate();
		
		return panel;
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	static Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}

	/**
	 * \ől̓tB[h̃Xi[
	 *
	 */
	private class MaxCountListener implements ActionListener
	{
		/**
		 * ͂ꂽ\őlŉʂXVB
		 * A10ȉ̏ꍇ́A10ƂB
		 *
		 * @param e ActionEvent
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			try {
				int max = Integer.parseInt(maxField.getText());
				if (max < 10) max = 10;
				processStartBar.setMaxCount(max);
				activityStartBar.setMaxCount(max);
				activityEndBar.setMaxCount(max);
				processEndBar.setMaxCount(max);
				LineViewModel model = graphView.getModel();
				model.setMaxCount(max);
				
				String maxStr = "" + max;
				maxField.setText(maxStr);
				maxLabel.setText(maxStr);
			} catch (NumberFormatException ex) {
				LineViewModel model = graphView.getModel();
				int max = model.getMaxCount();
				String maxStr = "" + max;
				maxField.setText(maxStr);
			}
			QueueMonitorFrame.this.repaint();
		}
	}
	
	/**
	 * XVpxύXXi[
	 *
	 */
	private class IntervalListener implements ItemListener
	{
		/**
		 * IꂽXVpxKpB
		 *
		 * @param e ItemEvent
		 * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
		 */
		public void itemStateChanged(ItemEvent e)
		{
			QueueMonitorViewModel model = (QueueMonitorViewModel)graphView.getModel();
			int ix = intervalBox.getSelectedIndex();
			if (ix == 0) {
				setting.setInterval(MonitorSetting.INTERVAL_HIGH);
			} else if (ix == 2) {
				setting.setInterval(MonitorSetting.INTERVAL_LOW);
			} else if (ix == 3) {
				setting.setInterval(MonitorSetting.INTERVAL_STOP);
			} else {
				setting.setInterval(MonitorSetting.INTERVAL_MIDDLE);
			}

			if (timer.isRunning()) timer.stop();
			if (ix != 3) {
				timer.setInitialDelay(setting.getInterval());
				timer.setDelay(setting.getInterval());
				timer.restart();
			}
			QueueMonitorFrame.this.repaint();
		}
	}
	
	/**
	 * ^C}[s鏈
	 *
	 */
	private class MonitorListener implements ActionListener
	{
		/**
		 * f[^x[Xf[^擾AʂXVB
		 *
		 * @param e ActionEvent
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			try {
				Connection conn = DriverManager.getConnection(
						setting.getURI(),
						setting.getUser(),
						setting.getPassword());
				int psqc = NauticaQueueDAO.getQueueCount(conn, QueueMonitor.START_PROCESS_REQUEST);
				int asqc = NauticaQueueDAO.getQueueCount(conn, QueueMonitor.START_ACTIVITY_REQUEST);
				int aeqc = NauticaQueueDAO.getQueueCount(conn, QueueMonitor.END_ACTIVITY_REQUEST);
				int peqc = NauticaQueueDAO.getQueueCount(conn, QueueMonitor.END_PROCESS_REQUEST);
				conn.close();

				processStartField.setText("" + psqc);
				activityStartField.setText("" + asqc);
				activityEndField.setText("" + aeqc);
				processEndField.setText("" + peqc);

				processStartBar.setCount(psqc);
				activityStartBar.setCount(asqc);
				activityEndBar.setCount(aeqc);
				processEndBar.setCount(peqc);
				
				QueueMonitorViewModel model = (QueueMonitorViewModel)graphView.getModel();
				model.putValue(QueueMonitor.START_PROCESS_REQUEST, psqc);
				model.putValue(QueueMonitor.START_ACTIVITY_REQUEST, asqc);
				model.putValue(QueueMonitor.END_ACTIVITY_REQUEST, aeqc);
				model.putValue(QueueMonitor.END_PROCESS_REQUEST, peqc);
			} catch (SQLException ex) {
				ResourceManager rm = QueueMonitor.getResourceManager();

				JOptionPane.showMessageDialog(
						QueueMonitorFrame.this,
						rm.getResource("E9101"),
				        rm.getResource("QueueMonitorFrame.error"),
						JOptionPane.ERROR_MESSAGE
					);
				setting.setInterval(MonitorSetting.INTERVAL_STOP);
				intervalBox.setSelectedIndex(3);				
				if (timer.isRunning()) timer.stop();
				return;
			}
			timer.restart();
			QueueMonitorFrame.this.repaint();
		}
	}
}
