/* $Id: QueueMonitor.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon;

import java.sql.Connection;
import java.sql.DriverManager;

import javax.swing.UIManager;

import jp.co.argo21.nautica.tool.qmon.common.ResourceManager;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/**
 * Nautica Workflow�̃��b�Z�[�W�L���[��Ď����郂�j�^�[���[�e�B���e�B�B
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class QueueMonitor
{
	/** �v���Z�X�J�n�҂��L���[�� */
	static public final String START_PROCESS_REQUEST  = "queue://START_PROCESS_REQUEST";
	/** �A�N�e�B�r�e�B�J�n�҂��L���[�� */
	static public final String START_ACTIVITY_REQUEST = "queue://START_ACTIVITY_REQUEST";
	/** �A�N�e�B�r�e�B�I���҂��L���[�� */
	static public final String END_ACTIVITY_REQUEST   = "queue://END_ACTIVITY_REQUEST";
	/** �v���Z�X�I���҂��L���[�� */
	static public final String END_PROCESS_REQUEST    = "queue://END_PROCESS_REQUEST";

	/** �o���h���p�X�� */
	static private final String BUNDLE_PATH
		= "jp.co.argo21.nautica.tool.qmon.resources.messages";
	/** ���\�[�X�}�l�[�W�� */
	static private ResourceManager resourceManager;

	/** �I�v�V���� */
	static private Options startOpts = new Options();
	/** �w���v�`�� */
	static private HelpFormatter formatter = new HelpFormatter();
	
	static
	{
		resourceManager = new ResourceManager(BUNDLE_PATH);

		Option driverOption = new Option("D", true,  "JDBC driver class name\n(org.gjt.mm.mysql.Driver).");
		driverOption.setArgName("JDBC driver class name");
		Option uriOption = new Option("C", true,  "JDBC URI(jdbc:mysql://127.0.0.1/nautica).");
		uriOption.setArgName("JDBC URI");
		Option userOption = new Option("u", true,  "DB user name(nautica).");
		userOption.setArgName("user");
		Option passwordOption = new Option("p", true,  "DB user password(nautica).");
		passwordOption.setArgName("password");
		Option intervalOption = new Option("i", true,  "Monitoring interval.");
		intervalOption.setArgName("H | M | L");
		Option maxCountOption = new Option("m", true,  "Max count(min:10).");
		maxCountOption.setArgName("Max count");
		Option helpOption = new Option("h", false, "Show help.");

		startOpts.addOption(driverOption);
		startOpts.addOption(uriOption);
		startOpts.addOption(userOption);
		startOpts.addOption(passwordOption);
		startOpts.addOption(intervalOption);
		startOpts.addOption(maxCountOption);
		startOpts.addOption(helpOption);
	}

	/**
	 * QueteMonitor�̃��C�����\�b�h
	 *
	 * @param args ��
	 */
	static public void main(String[] args)
	{
		CommandLineParser parser = new BasicParser();
		MonitorSetting setting = new MonitorSetting();

		try {
			CommandLine cl = parser.parse(startOpts, args);
			if (cl.hasOption("h")) {
				formatter.printHelp( "Queue Monitor", startOpts, true);
				System.exit(0);
			}

			if (cl.hasOption("D")) {
				String opt = cl.getOptionValue("D");
				if (opt == null) throw new ParseException("JDBC driver name not found.");
				setting.setDriverName(opt);
			}

			if (cl.hasOption("C")) {
				String opt = cl.getOptionValue("C");
				if (opt == null) throw new ParseException("JDBC URI not found.");
				setting.setURI(opt);
			}

			if (cl.hasOption("u")) {
				String opt = cl.getOptionValue("u");
				if (opt == null) throw new ParseException("DB user name not found.");
				setting.setUser(opt);
			}

			if (cl.hasOption("p")) {
				String opt = cl.getOptionValue("p");
				if (opt == null) throw new ParseException("DB user password not found.");
				setting.setPassword(opt);
			}

			if (cl.hasOption("i")) {
				String opt = cl.getOptionValue("i");
				if (opt == null) throw new ParseException("Inteval not found.");
				else if (opt.equals("H")) setting.setInterval(MonitorSetting.INTERVAL_HIGH);
				else if (opt.equals("M")) setting.setInterval(MonitorSetting.INTERVAL_MIDDLE);
				else if (opt.equals("L")) setting.setInterval(MonitorSetting.INTERVAL_LOW);
				else throw new ParseException("Invalid interval string.");
			}

			if (cl.hasOption("m")) {
				String opt = cl.getOptionValue("m");
				if (opt == null) throw new ParseException("Max count not found.");
				
				try {
					int max = Integer.parseInt(opt);
					if (max < 10) throw new ParseException("Max count must be above 10.");
					setting.setMaxCount(max);
				} catch (NumberFormatException ex) {
					throw new ParseException("Invalid max count.");
				}
			}
			
			testConnection(setting);
			
			//Java library Bug.   Bug ID:6600674
			//UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			
			new QueueMonitorFrame(setting).setVisible(true);
		} catch (ParseException ex) {
			formatter.printHelp( "Queue Monitor", startOpts, true);
			System.exit(-1);
		} catch (Exception ex) {
			ex.printStackTrace();
			System.exit(-1);
		}
	}

	/**
	 * ���\�[�X�}�l�[�W����Ԃ��B
	 *
	 * @return	���\�[�X�}�l�[�W��
	 */
	static public ResourceManager getResourceManager()
	{
		return resourceManager;
	}

	/**
	 * JDBC�ڑ��̃e�X�g��s���B
	 *
	 * @param setting �ݒ���
	 * @throws Exception �C�ӂ̗�O
	 */
	static private void testConnection(MonitorSetting setting) throws Exception
	{
		Class.forName(setting.getDriverName());
		Connection con = DriverManager.getConnection(
				setting.getURI(),
				setting.getUser(),
				setting.getPassword());
		con.close();
	}
}
