/* $Id: MonitorSetting.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon;

/**
 * Queue Monitor�ｽﾌ設抵ｿｽ�ｽ�ｽ�ｽﾇ暦ｿｽ�ｽ�ｽ�ｽ�ｽB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class MonitorSetting
{
	/** �ｽX�ｽV�ｽp�ｽx�ｽF�ｽ�ｽ */
	static public final int INTERVAL_HIGH   = 1000;
	/** �ｽX�ｽV�ｽp�ｽx�ｽF�ｽ�ｽ */
	static public final int INTERVAL_MIDDLE = 2000;
	/** �ｽX�ｽV�ｽp�ｽx�ｽF�ｽ�ｽ */
	static public final int INTERVAL_LOW    = 5000;
	/** �ｽX�ｽV�ｽp�ｽx�ｽF�ｽ齊橸ｿｽ�ｽ~ */
	static public final int INTERVAL_STOP   = -1;

	/** JDBC�ｽh�ｽ�ｽ�ｽC�ｽo�ｽ[�ｽﾌク�ｽ�ｽ�ｽX�ｽ�ｽ */
	private String driverName;
	/** JDBC URI */
	private String uri;
	/** �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽ�ｽ�ｽ[�ｽU */
	private String user;
	/** �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽp�ｽX�ｽ�ｽ�ｽ[�ｽh */
	private String password;
	/** �ｽX�ｽV�ｽp�ｽx */
	private int interval;
	/** �ｽ\�ｽ�ｽ�ｽﾅ托ｿｽl */
	private int maxCount;

	/**
	 * �ｽﾝ抵ｿｽ�ｽ�ｽｶ撰ｿｽ�ｽ�ｽ�ｽ�ｽB
	 */
	public MonitorSetting()
	{
		driverName = "org.apache.derby.jdbc.ClientDriver";
		uri = "jdbc:derby://127.0.0.1:1527/SystemDatabase";
		user = "nautica";
		password = "nautica";
		interval = INTERVAL_MIDDLE;
		maxCount = 10;
	}

	/**
	 * JDBC�ｽh�ｽ�ｽ�ｽC�ｽo�ｽ[�ｽﾌク�ｽ�ｽ�ｽX�ｽ�ｽ�ｽ�ｽﾔゑｿｽ�ｽB
	 *
	 * @return JDBC�ｽh�ｽ�ｽ�ｽC�ｽo�ｽ[�ｽﾌク�ｽ�ｽ�ｽX�ｽ�ｽ
	 */
	public String getDriverName()
	{
		return driverName;
	}

	/**
	 * �ｽX�ｽV�ｽp�ｽx�ｽ�ｽﾔゑｿｽ�ｽB
	 *
	 * @return �ｽX�ｽV�ｽp�ｽx
	 */
	public int getInterval()
	{
		return interval;
	}

	/**
	 * �ｽ\�ｽ�ｽ�ｽﾅ托ｿｽl�ｽ�ｽﾔゑｿｽ�ｽB
	 *
	 * @return �ｽ\�ｽ�ｽ�ｽﾅ托ｿｽl
	 */
	public int getMaxCount()
	{
		return maxCount;
	}

	/**
	 * �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽp�ｽX�ｽ�ｽ�ｽ[�ｽh�ｽ�ｽﾔゑｿｽ�ｽB
	 *
	 * @return �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽp�ｽX�ｽ�ｽ�ｽ[�ｽh�ｽﾌ値
	 */
	public String getPassword()
	{
		return password;
	}

	/**
	 * JDBC URI�ｽ�ｽﾔゑｿｽ�ｽB
	 *
	 * @return JDBC URI
	 */
	public String getURI()
	{
		return uri;
	}

	/**
	 * �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽ�ｽ�ｽ[�ｽU�ｽ�ｽﾔゑｿｽ�ｽB
	 *
	 * @return �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽ�ｽ�ｽ[�ｽU
	 */
	public String getUser()
	{
		return user;
	}

	/**
	 * JDBC�ｽh�ｽ�ｽ�ｽC�ｽo�ｽ[�ｽﾌク�ｽ�ｽ�ｽX�ｽ�ｽ�ｽ�ｽﾝ定す�ｽ�ｽB
	 * 
	 * @param driverName JDBC�ｽh�ｽ�ｽ�ｽC�ｽo�ｽ[�ｽﾌク�ｽ�ｽ�ｽX�ｽ�ｽ
	 */
	public void setDriverName(String driverName)
	{
		this.driverName = driverName;
	}

	/**
	 * �ｽX�ｽV�ｽp�ｽx�ｽ�ｽﾝ定す�ｽ�ｽB
	 * 
	 * @param interval �ｽX�ｽV�ｽp�ｽx
	 */
	public void setInterval(int interval)
	{
		this.interval = interval;
	}

	/**
	 * �ｽ\�ｽ�ｽ�ｽﾅ托ｿｽl�ｽ�ｽﾝ定す�ｽ�ｽB
	 * 
	 * @param maxCount �ｽ\�ｽ�ｽ�ｽﾅ托ｿｽl
	 */
	public void setMaxCount(int maxCount)
	{
		this.maxCount = maxCount;
	}

	/**
	 * �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽp�ｽX�ｽ�ｽ�ｽ[�ｽh�ｽ�ｽﾝ定す�ｽ�ｽB
	 * 
	 * @param password �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽp�ｽX�ｽ�ｽ�ｽ[�ｽh
	 */
	public void setPassword(String password)
	{
		this.password = password;
	}

	/**
	 * JDBC URI�ｽ�ｽﾝ定す�ｽ�ｽB
	 * 
	 * @param uri JDBC URI
	 */
	public void setURI(String uri)
	{
		this.uri = uri;
	}

	/**
	 * �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽ�ｽ�ｽ[�ｽU�ｽ�ｽﾝ定す�ｽ�ｽB
	 * 
	 * @param user �ｽf�ｽ[�ｽ^�ｽx�ｽ[�ｽX�ｽ�ｽ�ｽ[�ｽU
	 */
	public void setUser(String user)
	{
		this.user = user;
	}
}
