/* $Id: LineViewModel.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.swing;

import java.awt.Color;

/**
 * LineViewp̃f쐬̂߂̃C^tF[X
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public interface LineViewModel
{
	/**
	 * \őlԂB
	 *
	 * @return \ől
	 */
	public int getMaxCount();

	/**
	 * őJԂB
	 *
	 * @return őJ
	 */
	public int getMaxColumn();

	/**
	 * ǗĂJeS̐ԂB
	 *
	 * @return JeS
	 */
	public int getCategoryCount();

	/**
	 * CfNXɑΉJeSԂB
	 *
	 * @param index CfNX
	 * @return JeS
	 */
	public String getCategoryName(int index);

	/**
	 * JeS̎w肳ꂽJ̒lԂB
	 *
	 * @param category JeS
	 * @param colIndex JCfNX
	 * @return f[^l
	 */
	public int getValue(String category, int colIndex);

	/**
	 * JeS̑OiFԂB
	 *
	 * @param category JeS
	 * @return OiF
	 */
	public Color getForegound(String category);

	/**
	 * JeS̔wiFԂB
	 *
	 * @param category JeS
	 * @return wiF
	 */
	public Color getBackground(String category);

	/**
	 * ő\ݒ肷B
	 *
	 * @param maxCount ő\
	 */
	public void setMaxCount(int maxCount);

	/**
	 * őJݒ肷B
	 *
	 * @param maxColumn őJ
	 */
	public void setMaxColumn(int maxColumn);

	/**
	 * JeSɒlǉB
	 *
	 * @param category JeS
	 * @param value l 
	 */
	public void putValue(String category, int value);

	/**
	 * w肳ꂽJeSo^B
	 *
	 * @param name JeS
	 * @param foreground OiF
	 * @param background wiF
	 */
	public void addCategory(String name, Color foreground, Color background);
}
