/* $Id: ResourceManager.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon.common;

import java.util.*;

/**
 * AvP[Vp̕񃊃\[XNXłB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class ResourceManager
{
	/** \[Xoh */
	private ResourceBundle resources;

	/**
	 * \[X}l[W𐶐B
	 * 
	 * @param bundlePath \[Xoh̃pX
	 */
	public ResourceManager(String bundlePath)
	{
		try {
			resources = ResourceBundle.getBundle(bundlePath, Locale.getDefault());
		} catch (MissingResourceException ex) {}
	}

	/**
	 * w肳ꂽL[ɊY郊\[XԂB
	 * Y郊\[XȂꍇ́AL[̂̂ԂB
	 *
	 * @param key L[
	 * @return \[X
	 */
	public String getResource(String key)
	{
		try {
			return resources.getString(key);
		} catch (Exception ex) {
			return key;
		}
	}

	/**
	 * w肳ꂽL[ɊY郊\[XԂB
	 * Y郊\[XȂꍇ́A֒lԂB
	 *
	 * @param key L[
	 * @param alt ֒l
	 * @return \[X
	 */
	public String getResource(String key, String alt)
	{
		try {
			return resources.getString(key);
		} catch (Exception ex) {
			return alt;
		}
	}
}
