/* $Id: QueueMonitorViewModel.java,v 1.1 2008/01/21 08:44:54 knakata Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Queue Monitor.
 * 
 *  Nautica Queue Monitor is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Queue Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Queue Monitor; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.qmon;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

import jp.co.argo21.nautica.tool.qmon.swing.LineViewModel;

/**
 * QueueMonitorp̐܂Ot\郂f
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Queue Monitor 0.1
 */
public class QueueMonitorViewModel implements LineViewModel
{
	/** JeS */
	private ArrayList categories = new ArrayList();
	
	/** \ől */
	private int maxCount = 10;
	/** őJ */
	private int maxColumn = 20;

	/**
	 * QueueMonitorp̐܂Ot\郂f𐶐B
	 *
	 * @param maxCount \ől
	 * @param maxColumn őJ
	 */
	public QueueMonitorViewModel(int maxCount, int maxColumn)
	{
		this.maxCount = maxCount;
		this.maxColumn = maxColumn;
	}

	/**
	 * ǗĂJeS̐ԂB
	 *
	 * @return JeS
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getCategoryCount()
	 */
	public int getCategoryCount()
	{
		return categories.size();
	}

	/**
	 * CfNXɑΉJeSԂB
	 *
	 * @param index CfNX
	 * @return JeS
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getCategoryName(int)
	 */
	public String getCategoryName(int index)
	{
		synchronized (this) {
			Category cat = (Category)categories.get(index);
			return cat.name;
		}
	}

	/**
	 * őJԂB
	 *
	 * @return őJ
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getMaxColumn()
	 */
	public int getMaxColumn()
	{
		return maxColumn;
	}

	/**
	 * \őlԂB
	 *
	 * @return \ől
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getMaxCount()
	 */
	public int getMaxCount()
	{
		return maxCount;
	}

	/**
	 * JeS̎w肳ꂽJ̒lԂB
	 *
	 * @param category JeS
	 * @param colIndex JCfNX
	 * @return f[^l
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getValue(java.lang.String, int)
	 */
	public int getValue(String category, int colIndex)
	{
		Category cat = (Category)getCategory(category);
		return cat.getValueAt(colIndex);
	}

	/**
	 * JeS̑OiFԂB
	 *
	 * @param category JeS
	 * @return OiF
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getForegound(java.lang.String)
	 */
	public Color getForegound(String category)
	{
		Category cat = (Category)getCategory(category);
		if (cat == null) return Color.white;
		return cat.getForeground();
	}

	/**
	 * JeS̔wiFԂB
	 *
	 * @param category JeS
	 * @return wiF
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#getBackground(java.lang.String)
	 */
	public Color getBackground(String category)
	{
		Category cat = (Category)getCategory(category);
		if (cat == null) return Color.white;
		return cat.getBackground();
	}

	/**
	 * őJݒ肷B
	 *
	 * @param maxColumn őJ
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#setMaxColumn(int)
	 */
	public void setMaxColumn(int maxColumn)
	{
		this.maxColumn = maxColumn;
		synchronized (this) {
			Iterator it = categories.iterator();
			while (it.hasNext()) {
				Category cat = (Category)it.next();
				cat.recalc();
			}
		}
	}

	/**
	 * ő\ݒ肷B
	 *
	 * @param maxCount ő\
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#setMaxCount(int)
	 */
	public void setMaxCount(int maxCount)
	{
		this.maxCount = maxCount;
	}

	/**
	 * JeSɒlǉB
	 *
	 * @param category JeS
	 * @param value l 
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#putValue(java.lang.String, int)
	 */
	public void putValue(String category, int value)
	{
		Category cat = (Category)getCategory(category);
		cat.addNewValue(value);
	}

	/**
	 * w肳ꂽJeSo^B
	 *
	 * @param name JeS
	 * @param foreground OiF
	 * @param background wiF
	 * @see jp.co.argo21.nautica.tool.qmon.swing.LineViewModel#addCategory(jp.co.argo21.nautica.tool.qmon.swing.LineViewCategory)
	 */
	public void addCategory(String name, Color foreground, Color background)
	{
		Category cat = new Category(name, foreground, background);
		cat.init();
		synchronized (this) {
			categories.add(cat);
		}
	}

	/**
	 * JeSԂB
	 *
	 * @param name JeS
	 * @return JeS
	 */
	private Category getCategory(String name)
	{
		Iterator it = categories.iterator();
		while (it.hasNext()) {
			Category cat = (Category)it.next();
			if (cat.name.equals(name)) return cat;
		}
		return null;
	}
	
	/**
	 * JeSf[^̊Ǘ
	 */
	private class Category
	{
		/** JeS */
		private String name;
		/** OiF */
		private Color foreground;
		/** wiF */
		private Color background;
		/** f[^Ǘ */
		private ArrayList data = new ArrayList();

		/**
		 * JeS𐶐B
		 *
		 * @param name JeS
		 * @param foreground OiF
		 * @param background wiF
		 */
		private Category(String name, Color foreground, Color background)
		{
			this.name = name;
			this.foreground = foreground;
			this.background = background;
		}
		
		/**
		 * JeSB
		 */
		private synchronized void init()
		{
			data.clear();
			for (int i = 0; i < maxColumn; i++) {
				data.add(new Integer(0));
			}
		}
		
		/**
		 * JeSf[^ČvZB
		 */
		private synchronized void recalc()
		{
			int size = data.size();
			if (size < maxColumn) {
				for (int i = 0; i < (maxColumn - size); i++) {
					data.remove(0);
				}
			} else if (size > maxColumn) {
				for (int i = 0; i < (size - maxColumn); i++) {
					data.add(new Integer(0));
				}
			}
		}

		/**
		 * JeSԂB
		 *
		 * @return JeS
		 */
		private String getName()
		{
			return name;
		}

		/**
		 * OiFԂB
		 *
		 * @return OiF
		 */
		private Color getForeground()
		{
			return foreground;
		}

		/**
		 * wiFԂB
		 *
		 * @return wiF
		 */
		private Color getBackground()
		{
			return background;
		}

		/**
		 * CfNXŎw肳ꂽlԂB
		 *
		 * @param index CfNX
		 * @return f[^l
		 */
		private synchronized int getValueAt(int index)
		{
			Integer integer = (Integer)data.get(index);
			int value = integer.intValue();
			return value;
		}
		
		/**
		 * VlǉB
		 *
		 * @param value f[^l
		 */
		private synchronized void addNewValue(int value)
		{
			data.remove(0);
			data.add(new Integer(value));
		}
	}
}
