/* $Id: UniqueKeyGenerator.java,v 1.1 2008/01/11 09:08:49 stokin Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.sample.util;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.model.dao.KeySeqDAO;

/**
 * ユニークキーを生成するジェネレータクラス。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 0.9
 */
public class UniqueKeyGenerator {

	/**
	 * 指定された申請名のユニークキーを生成する。
	 * 
	 * @param appkind 申請名
	 * @return ユニークキー
	 */
	static public String generate(String appkind)	throws SQLException {

        Date date = new Date();
        SimpleDateFormat formatter;
        StringBuffer number = new StringBuffer();
        
        formatter = new SimpleDateFormat("yyyy");
        number.append(formatter.format(date));
       
        formatter = new SimpleDateFormat("MM");
        number.append(formatter.format(date));
        
        formatter = new SimpleDateFormat("dd");
        number.append(formatter.format(date));
        
        KeySeqDAO keyseqdao = DAOFactory.getKeySeqDAO();
        number.append(keyseqdao.next(appkind));
        
        return number.toString();
	}
}
