package jp.co.argo21.nautica.workflow.sample.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;

/**
 * リソースを管理する。
 * 
 * @author stokin
 *
 */
public class ResourceManager {

    private static final ResourceBundle bundle 
    	= ResourceBundle.getBundle("jp.co.argo21.nautica.workflow.sample.resource.ApplicationResources");
	
	private static final ResourceManager resourceManager = new ResourceManager();
	
	/**
	 * コンストラクタ
	 */
	private ResourceManager(){
		try {
			Class.forName("com.mysql.jdbc.Driver").newInstance();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * このクラスのインスタンスを返す。
	 * 
	 * @return このクラスのインスタンス
	 */
	public static ResourceManager getInstance(){
		return resourceManager;
	}
	
	/**
	 * DBとの接続を返す。
	 * @return　DBとの接続
	 * @throws SQLException　DBとの接続の取得に失敗した場合
	 */
	public Connection getConnection() throws SQLException{
		Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/nautica?"
				+ "user=nautica&password=nautica");
		return conn;
	}

	/**
	 * DBとの接続を切断する。
	 * 
	 * @param conn　DBとの接続
	 * @param statement　ステートメント
	 * @throws SQLException　DBとの切断に失敗した場合
	 */
	public void closeConnection(Connection conn, Statement statement) throws SQLException{
		if (statement != null) {
			statement.close();
		}
		if ( (conn != null) && (!conn.isClosed())) {		
			conn.close();
		}		
	}
	
	/**
	 * DBとの接続を切断する。
	 * 
	 * @param conn　DBとの接続
	 * @throws SQLException　DBとの切断に失敗した場合
	 */
	public void closeConnection(Connection conn) throws SQLException {
        if ( (conn != null) && (!conn.isClosed())) {        
            conn.close();
        }
    }
	
	/**
	 * メッセージを取得する。
	 * 
	 * @param key　キー
	 * @return　メッセージ
	 */
    public String getValue(String key) {
        return bundle.getString(key);
    }
}
