/* $Id: DAOFactory.java,v 1.1 2008/01/11 09:08:49 stokin Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.model.dao;

import jp.co.argo21.nautica.workflow.sample.model.AppKind;

/**
 * DAOt@NgNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 0.9
 */
public class DAOFactory {

    /**
     * L[V[PXDAOԂB
     * 
     * @return L[V[PXDAO
     */
    public static KeySeqDAO getKeySeqDAO() {
        return new KeySeqDAO();
    }
    
    /**
     * \DAOԂB
     * 
     * @return \DAO
     */
    public static AppKindDAO getAppKindDAO() {
        return new AppKindDAO();
    }
    
    /**
     * \gUNVDAOԂB
     * 
     * @return \gUNVDAO
     */
    public static AppTransactionDAO getAppTransactionDAO() {
        return new AppTransactionDAO();
    }
    
    /**
     * ԊOJ\DAOԂB
     * 
     * @return ԊOJ\DAO
     */
    static OvertimeAppDAO getOvertimeAppDAO() {
        return new OvertimeAppDAO();
    }
    
    /**
     * w肳ꂽ\ʃR[hDAOԂB
     * 
     * @param appKindID \ʃR[h
     * @return Cӂ̐\DAO
     */
    public static ApplicationDAO getApplicationDAOFromAppKindID(String appKindID) {
        if (appKindID.equals(AppKind.OVERTIME_APPLICATION_ID)) {
            return getOvertimeAppDAO();
        }
        return null;
    }
    
    /**
     * \DAOԂB
     * 
     * @return \DAO
     */
    public static ApplicationDAO getApplicationDAO( ) {
        return new ApplicationDAO();
    }       
    
}