package jp.co.argo21.nautica.workflow.sample.util;

import java.util.ArrayList;
import java.util.List;

import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;

/**
 * Webサービス通信関係のユーティリティクラス
 * 
 * @author stokin
 * 
 */
public class WebServiceUtil {
	
	/**
	 * プロセス変数に値を割り当てる。
	 * 
	 * @param sessionID セッションID
	 * @param pid プロセスID
	 * @param name 変数名
	 * @param value 値
	 * @throws Exception 値の割り当てに失敗した場合
	 */
	public static void assignProcessAttribute(String sessionID, String pid, String name, String value) throws Exception {
		assignProcessAttribute(sessionID, pid, name, value, 1);
	}
	
	/**
	 * プロセス変数に値を割り当てる。
	 * @param sessionID セッションID
	 * @param pid プロセスID
	 * @param name 変数名
	 * @param value 値
	 * @param type 値の変数型
	 * 
	 * @throws Exception 値の割り当てに失敗した場合
	 */
	public static void assignProcessAttribute(String sessionID, String pid, String name, String value, int type) throws Exception{
		Attribute attribute = new Attribute();
		attribute.setName(name);
		attribute.setValue(value);
		attribute.setType(type);
		
		WorkflowEngineHandler wfEngineHandler = ServiceAccessor.getInstance().getWfEngineHandler();
		wfEngineHandler.assignProcessAttribute(sessionID, pid, attribute);
	}
	
	/**
	 * 作業項目変数に値を割り当てる。
	 * 
	 * @param sessionID セッションID
	 * @param wid 作業項目ID
	 * @param name 変数名
	 * @param value 値
	 * @throws Exception 値の割り当てに失敗した場合
	 */
	public static void assignWorkItemAttribute(String sessionID, String wid, String name, String value) throws Exception{
		assignWorkItemAttribute(sessionID, wid, name, value, 1);
	}
	
	/**
	 * 作業項目変数に値を割り当てる。
	 * @param sessionID セッションID
	 * @param wid 作業項目ID
	 * @param name 変数名
	 * @param value 値
	 * @param type 値の変数型
	 * 
	 * @throws Exception 値の割り当てに失敗した場合
	 */
	public static void assignWorkItemAttribute(String sessionID, String wid, String name, String value, int type) throws Exception{
		Attribute attribute = new Attribute();
		attribute.setName(name);
		attribute.setValue(value);
		attribute.setType(type);
		WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
		wiHandler.assignWorkItemAttribute(sessionID, wid, attribute);
	}
	
	/**
	 * 属性フィルタを作成する。
	 * 
	 * @param name 属性名
	 * @param value 値
	 * @return 属性フィルタ
	 */
	public static List<Filter> createEqualAttributeFilter(String name, String value){
		List<Filter> filterList = new ArrayList<Filter>();
		Filter filter = new Filter();
		filter.setFilterName(name);
		filter.setFilterString(value);
		filter.setType(5003);
		filter.setComparison(1);
		filterList.add(filter);
		return filterList;
	}
	
	/**
	 * 状態フィルタを作成する。
	 * 
	 * @param name 状態名
	 * @param state 状態
	 * @return 状態フィルタ
	 */
	public static List<Filter> createEqualStateFilter(String name, String state){
		List<Filter> filterList = new ArrayList<Filter>();
		Filter filter = new Filter();
		filter.setFilterName(name);
		filter.setFilterString(state);
		filter.setType(5002);
		filter.setComparison(1);
		filterList.add(filter);
		return filterList;
	}
}
