package jp.co.argo21.nautica.workflow.sample.util;

import java.util.ArrayList;
import java.util.List;

import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;

/**
 * 入力内容の妥当性をチェックする。
 * 
 * @author stokin
 *
 */
public class Validator {

	/**
	 * 入力内容の妥当性をチェックする。
	 * 
	 * @param content 入力内容
	 * @throws ValidatorException 入力内容が不当な場合
	 */
	public static void validate(OvertimeApp content) throws ValidatorException{
		List<String> errMsgs = new ArrayList<String>();
		ResourceManager rm = ResourceManager.getInstance();
		int startHour = content.getStartHour();
		int startMin = content.getStartMin();
		int endHour = content.getEndHour();
		int endMin = content.getEndMin();
		float overtimeHours = content.getOvertimeHours();

		int startTime = timeToMinute(startHour, startMin);
		int endTime = timeToMinute(endHour, endMin);
		int overtimeMins = endTime - startTime;

		// 終了予定時刻が開始予定時刻よりも早い場合はエラー
		if (startTime > endTime) {
			errMsgs.add(rm.getValue("error.endStart"));
		} 

		// 予定時刻が30分間隔で指定されていない場合はエラー
		if (((overtimeMins) % 30) != 0 ){ 
			errMsgs.add(rm.getValue("error.time"));
		}

		// 予定時間が予定時刻の幅をオーバーする場合はエラー
		if(overtimeHours > (float)(endTime - startTime)/60){
			errMsgs.add(rm.getValue("error.hour"));
		}

		// 事由が空の場合はエラー
		if (content.getReason().isEmpty()){
			errMsgs.add("事由" + rm.getValue("error.empty"));
		}

		//エラーが１つ以上あったら例外
		if (errMsgs.size() != 0){
			throw new ValidatorException(errMsgs);
		}

	}

	/**
	 * 時刻を分に変換する。
	 * 
	 * @param hour 時
	 * @param min 分
	 * @return 時刻を分で表したもの
	 */
	private static int timeToMinute(int hour, int min){
		return hour * 60 + min;
	}
}
