package jp.co.argo21.nautica.workflow.sample.util;

import java.util.Locale;

import jp.co.argo21.nautica.workflow.soap.message.User;

/**
 * 文字列を操作するユーティリティクラス
 * 
 * @author stokin
 *
 */
public class StringUtil {
	
	/**
	 * フルネームを返す。
	 * 
	 * @param user ユーザ
	 * @return フルネーム
	 */
	public static String toFullName(User user){
		String firstname = user.getFirstname();
		String lastname = user.getLastname();
		if (Locale.getDefault().toString().equals("ja_JP")) {
            return lastname + " " + firstname;
    	} else {
    		return firstname + ", " + lastname;
    	}
	}
}
