package jp.co.argo21.nautica.workflow.sample.util;
import java.io.IOException;

import javax.naming.NamingException;

import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.soap.message.InvalidSessionException;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager;
import jp.co.argo21.nautica.workflow.soap.RoleManager;
import jp.co.argo21.nautica.workflow.soap.UserManager;
//import jp.co.argo21.nautica.workflow.security.OrganizationManager;
//import jp.co.argo21.nautica.workflow.security.RoleManager;
//import jp.co.argo21.nautica.workflow.security.UserManager;
//import jp.co.argo21.nautica.workflow.util.GeronimoUtils;
//import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
//import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
//import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;

/**
 * Nauticaにアクセスするためのオブジェクトを返す。
 * DAOから使われている。
 * 実際の処理はServiceAccessorに委譲する。
 * 
 * @author stokin
 *
 */
public class SingletonServices {

	private static final SingletonServices singleton = new SingletonServices();

	/**
	 * コンストラクタ
	 */
	private SingletonServices(){}

	/**
	 * このクラスのインスタンスを返す。
	 * 
	 * @return インスタンス
	 */
	public static SingletonServices getInstance() {	
		return singleton;
	}

	/**
	 * UserManagerクラスのオブジェクトを返す。
	 * 
	 * @return　UserManagerオブジェクト
	 */
	public UserManager getUserManager() {
		return ServiceAccessor.getInstance().getUserManager();
	}
	
	/**
	 * OrganizationManagerクラスのオブジェクトを返す。
	 * 
	 * @return　OrganizationManagerオブジェクト
	 */
	public OrganizationManager getOrganizationManager() {
		return ServiceAccessor.getInstance().getOrganizationManager();
	}
	
	/**
	 * RoleManagerクラスのオブジェクトを返す。
	 * 
	 * @return　RoleManagerオブジェクト
	 */
	public RoleManager getRoleManager() {
		return ServiceAccessor.getInstance().getRoleManager();
	}

	/**
	 * WorkItemHandlerクラスのオブジェクトを返す。
	 * 
	 * @return　WorkItemHandlerオブジェクト
	 */
	public WorkItemHandler getWfWorkitemHandler() {
		return ServiceAccessor.getInstance().getWorkItemHandler();
	}

}
