package jp.co.argo21.nautica.workflow.sample.util;

import jp.co.argo21.nautica.workflow.soap.DefinitionRepository;
import jp.co.argo21.nautica.workflow.soap.DefinitionRepository_Service;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager_Service;
import jp.co.argo21.nautica.workflow.soap.RoleManager;
import jp.co.argo21.nautica.workflow.soap.RoleManager_Service;
import jp.co.argo21.nautica.workflow.soap.UserManager;
import jp.co.argo21.nautica.workflow.soap.UserManager_Service;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler_Service;
import jp.co.argo21.nautica.workflow.soap.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowAdminHandler_Service;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler_Service;
import jp.co.argo21.nautica.workflow.soap.WorkflowServiceConnector;
import jp.co.argo21.nautica.workflow.soap.WorkflowServiceConnector_Service;

/**
 * Nauticaにアクセスするためのオブジェクトを返す。
 * 
 * @author stokin
 *
 */
public class ServiceAccessor
{
	private static ServiceAccessor singleton = new ServiceAccessor();

	private DefinitionRepository defRepository;
	private WorkflowAdminHandler wfAdmin;
	private WorkflowEngineHandler wfEngine;
	private WorkflowServiceConnector wfConnector;
	private WorkItemHandler wfItem;
	private UserManager usrManager;
	private RoleManager roleManager;
	private OrganizationManager orgManager;

	/**
	 * コンストラクタ
	 */
	private ServiceAccessor() {
		setDefRepository();
		setWfServiceConnector();
		setWfEngine();
		setWfAdmin();
		setWfItem();
		setUsrManager();
		setRoleManager();
		setOrganizationManager();
	}

	/**
	 * BeanSingletonクラスのインスタンスを返す。
	 * @return BeanSingletonクラスのインスタンス
	 */
	public static ServiceAccessor getInstance()
	{
		return singleton;
	}

	/**
	 * WorkflowServiceManagerクラスのインスタンスをセットする。
	 * @throws NamingException 
	 */
	private void setWfServiceConnector() {
		WorkflowServiceConnector_Service wsc = new WorkflowServiceConnector_Service();
		wfConnector = wsc.getWorkflowServiceConnectorPort();
	}

	/**
	 * WorkflowServiceManagerクラスのインスタンスを返す。
	 * @return WorkflowServiceManagerクラスのインスタンス
	 */
	public WorkflowServiceConnector getWfServiceConnector() {
		return wfConnector;
	}

	/**
	 * DefinitionRepositoryクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setDefRepository() {
		DefinitionRepository_Service drs = new DefinitionRepository_Service();
		defRepository = drs.getDefinitionRepositoryPort();
	}

	/**
	 * DefinitionRepowfAdmin = BeanSingleton.getInstance().getWfAdmin();sitoryクラスのインスタンスを返す。
	 * @return DefinitionRepositoryクラスのインスタンス
	 */
	public DefinitionRepository getDefRepository() {
		return defRepository; 
	}

	/**
	 * WorkflowEngineHandlerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setWfEngine() {
		WorkflowEngineHandler_Service wehs = new WorkflowEngineHandler_Service();
		wfEngine = wehs.getWorkflowEngineHandlerPort();
	}

	/**
	 * WorkflowEngineHandlerクラスのインスタンスを返す。
	 * @return WorkflowEngineHandlerクラスのインスタンス
	 */
	public WorkflowEngineHandler getWfEngineHandler() {
		return wfEngine;
	}

	/**
	 * WorkflowAdminHandlerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setWfAdmin() {
		WorkflowAdminHandler_Service wfah = new WorkflowAdminHandler_Service();
		wfAdmin = wfah.getWorkflowAdminHandlerPort();
	}

	/**
	 * WorkflowAdminHandlerクラスのインスタンスを返す。
	 * @return WorkflowAdminHandlerクラスのインスタンス
	 */
	public WorkflowAdminHandler getWfAdmin() {
		return wfAdmin;
	}

	/**
	 * WorkItemHandlerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setWfItem() {
		WorkItemHandler_Service wih = new WorkItemHandler_Service();
		wfItem = wih.getWorkItemHandlerPort();
	}

	/**
	 * WorkItemHandlerクラスのインスタンスを返す。
	 * @return WorkItemHandlerクラスのインスタンス
	 */
	public WorkItemHandler getWorkItemHandler() {
		return wfItem;
	}

	/**
	 * UserManagerクラスのインスタンスをセットする。
	 * 
	 */
	private void setUsrManager() {
		UserManager_Service um = new UserManager_Service();
		usrManager = um.getUserManagerPort();

	}

	/**
	 * UserManagerクラスのインスタンスを返す。
	 * @return UserManagerクラスのインスタンス
	 */
	public UserManager getUserManager() {
		return usrManager;
	}

	/**
	 * RoleManagerクラスのインスタンスをセットする。
	 * 
	 */
	private void setRoleManager() {
		RoleManager_Service rm = new RoleManager_Service();
		roleManager = rm.getRoleManagerPort();
	}

	/**
	 * RoleManagerクラスのインスタンスを返す。
	 * @return RoleManagerクラスのインスタンス
	 */
	public RoleManager getRoleManager() {
		return roleManager;
	}

	/**
	 * OrganizationManagerクラスのインスタンスをセットする。
	 * 
	 */
	private void setOrganizationManager() {
		OrganizationManager_Service om = new OrganizationManager_Service();
		orgManager = om.getOrganizationManagerPort();
	}

	/**
	 * OrganizationManagerクラスのインスタンスを返す。
	 * @return OrganizationManagerクラスのインスタンス
	 */
	public OrganizationManager getOrganizationManager()
	{
		return orgManager;
	}	
}