package jp.co.argo21.nautica.workflow.sample.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;

/**
 * HTML関係のユーティリティクラス
 * 
 * @author stokin
 *
 */
public class HtmlUtil {

	/**
	 * サニタイズする。
	 * 
	 * @param content サニタイズ対象
	 * @return サニタイズした文字列
	 */
	public static String sanitize(String content){
		if(content != null && !content.isEmpty()){
			String ampChecked = content.replaceAll("&", "&amp;");
			String leftChecked = ampChecked.replaceAll("<", "&lt;");
			String rightChecked = leftChecked.replaceAll(">", "&gt;");
			String quoteChecked = rightChecked.replaceAll("\"", "&quot");
			String allChecked = quoteChecked.replaceAll("\'", "&#39");
			return allChecked;
		} else {
			return content;
		}

	}

	/**
	 * サニタイズする。
	 * 
	 * @param overtimeApp 申請書の入力内容
	 * @return サニタイズした入力内容
	 */
	public static OvertimeApp sanitize(OvertimeApp overtimeApp){
		String reason = overtimeApp.getReason();
		overtimeApp.setReason(sanitize(reason));
		String remark = overtimeApp.getRemark();
		overtimeApp.setRemark(sanitize(remark));
		return overtimeApp;
	}
}
