package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.soap.InvalidSessionException;
import jp.co.argo21.nautica.workflow.soap.WorkflowServiceConnector;

/**
 * ログアウトする。
 * 
 * @author stokin
 *
 */
public class Logout extends HttpServlet {

	/**
	 * doPostに処理を委譲する。
	 * 
	 * @param req リクエスト
	 * @param res レスポンス
	 * @throws ServletException 発生しない
	 * @throws IOException forwardに失敗した場合
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
	throws ServletException, IOException {
		doPost(req, resp);
	}

	/**
	 * ログアウトする。
	 * 
	 * @param req リクエスト
	 * @param res レスポンス
	 * @throws ServletException 発生しない
	 * @throws IOException forwardに失敗した場合
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException{

		HttpSession session = req.getSession(true);
		String sessionID = (String)session.getAttribute("sessionID");
		ServletContext context = getServletContext();
		RequestDispatcher dispatcher;
		WorkflowServiceConnector wfServiceConnector = ServiceAccessor.getInstance().getWfServiceConnector();

		session.invalidate();
		try {
			if(sessionID != null) {
				wfServiceConnector.disconnect(sessionID);
			}
			dispatcher = context.getRequestDispatcher("/Logout.jsp");	
		} catch (InvalidSessionException e) {
			// 致命的エラー
			session.invalidate();			
			req.setAttribute("errMsg", e.toString());
			req.setAttribute("err", e.getStackTrace());
			dispatcher = context.getRequestDispatcher("/FatalError.jsp");
		}
		dispatcher.forward(req, res);
	}

}