-- サンプルアプリ用テーブル作成 

-- テーブル作成のための準備
SET SCHEMA NAUTICA;

-- テーブル名：キーシーケンス管理
-- テーブルID：WF_KEYSEQ
-- M/T：T
-- 備考：ユニークキー取得用
CREATE TABLE WF_KEYSEQ (
    NAME		VARCHAR(32)	NOT NULL	PRIMARY KEY,
    SEQ			INTEGER		NOT NULL	DEFAULT 0
);


-- テーブル名：申請種別
-- テーブルID：WF_APPKIND
-- M/T：M
-- 備考：
CREATE TABLE WF_APPKIND (
    APPKIND_ID		VARCHAR(128)	NOT NULL	PRIMARY KEY,
    APPKIND_NAME	VARCHAR(128)	NOT NULL,
    ROLE_ID		VARCHAR(64)	NOT NULL,
    APP_TABLE_NAME	VARCHAR(128)	NOT NULL,
    APPROVE_ACCOUNT	INTEGER		NOT NULL	DEFAULT 0,
    CONFIRM_ACCOUNT	INTEGER				DEFAULT 0
);

-- テーブル名：申請トランザクション
-- テーブルID：WF_APPTRANSACTION
-- M/T：T
-- 備考：
CREATE TABLE WF_APPTRANSACTION (
    APP_ID		VARCHAR(128)	NOT NULL,
    APPROVE_ACCOUNT_ID	INTEGER		NOT NULL,
    APPKIND_ID		VARCHAR(128)	NOT NULL,
    APP_STATUS		VARCHAR(128)	NOT NULL,
    APP_USER_ID		VARCHAR(64),
    APP_ROLE_ID		VARCHAR(64),
    COMMENT		VARCHAR(128),
    DATE		TIMESTAMP,
    PRIMARY KEY (APP_ID,APPROVE_ACCOUNT_ID)
);


-- テーブル名：申請
-- テーブルID：WF_APPLICATION
-- M/T：T
-- 備考：
CREATE TABLE WF_APPLICATION (
    APP_ID		VARCHAR(128)	NOT NULL	PRIMARY KEY,
    APPKIND_ID		VARCHAR(10)	NOT NULL,
    USER_ID		VARCHAR(20)	default NULL,
    APP_DATE		DATE		default NULL
);


-- テーブル名：時間外申請
-- テーブルID：WF_OVERTIMEAPP
-- M/T：T
-- 備考：
CREATE TABLE WF_OVERTIMEAPP (
    APP_ID		VARCHAR(128)	NOT NULL	PRIMARY KEY,
    WORKDAY		DATE,
    START_TIME		TIME		NOT NULL,
    END_TIME		TIME		NOT NULL,
    OVERTIME_HOURS	FLOAT,
    COMP_DAY		INTEGER		default NULL,
    COMP_DAY_DATE	DATE,
    REASON		VARCHAR(255),
    REMARKS		VARCHAR(255)
);
