/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.util;

import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.ValidatorException;

public class Validator {
    public static void validate(OvertimeApp content) throws ValidatorException {
        ArrayList<String> errMsgs = new ArrayList<String>();
        ResourceManager rm = ResourceManager.getInstance();
        int startHour = content.getStartHour();
        int startMin = content.getStartMin();
        int endHour = content.getEndHour();
        int endMin = content.getEndMin();
        float overtimeHours = content.getOvertimeHours();
        int startTime = Validator.timeToMinute(startHour, startMin);
        int endTime = Validator.timeToMinute(endHour, endMin);
        int overtimeMins = endTime - startTime;
        if (startTime > endTime) {
            errMsgs.add(rm.getValue("error.endStart"));
        }
        if (overtimeMins % 30 != 0) {
            errMsgs.add(rm.getValue("error.time"));
        }
        if (overtimeHours > (float)(endTime - startTime) / 60.0f) {
            errMsgs.add(rm.getValue("error.hour"));
        }
        if (content.getReason().isEmpty()) {
            errMsgs.add("\u4e8b\u7531" + rm.getValue("error.empty"));
        }
        if (errMsgs.size() != 0) {
            throw new ValidatorException(errMsgs);
        }
    }

    private static int timeToMinute(int hour, int min) {
        return hour * 60 + min;
    }
}

