/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;

public class OvertimeAppDAO
extends ApplicationDAO {
    private static final String WORKDAY = "WORKDAY";
    private static final String START_TIME = "START_TIME";
    private static final String END_TIME = "END_TIME";
    private static final String OVERTIME_HOURS = "OVERTIME_HOURS";
    private static final String REASON = "REASON";
    private static final String COMP_DAY = "COMP_DAY";
    private static final String COMP_DAY_DATE = "COMP_DAY_DATE";
    private static final String REMARKS = "REMARKS";
    private static ResourceManager locator = ResourceManager.getInstance();
    private static final String SQL_INSERT_APPNO = "insert into OVERTIMEAPP (APP_ID, START_TIME, END_TIME) values (?, ?, ?) ";
    private static final String SQL_SELECT_BY_ID = "select * from OVERTIMEAPP where APP_ID = ?";
    private static final String SQL_DELETE = "delete from OVERTIMEAPP where APP_ID = ?";
    private static final String SQL_UPDATE = "update OVERTIMEAPP SET WORKDAY = ?, START_TIME = ?, END_TIME = ?, OVERTIME_HOURS = ?, COMP_DAY = ?, COMP_DAY_DATE = ?, REMARKS = ?, REASON = ? where APP_ID = ?";

    @Override
    public void updateApplication(Application app) throws SQLException {
        OvertimeApp overtimeApp = (OvertimeApp)app;
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE);
        try {
            statement.setTimestamp(1, overtimeApp.getWorkday());
            statement.setTime(2, overtimeApp.getStartTime());
            statement.setTime(3, overtimeApp.getEndTime());
            statement.setFloat(4, overtimeApp.getOvertimeHours());
            if (overtimeApp.isComp()) {
                statement.setInt(5, 0);
                statement.setTimestamp(6, overtimeApp.getCompDay());
            } else {
                statement.setInt(5, 1);
                statement.setTimestamp(6, null);
            }
            statement.setString(7, overtimeApp.getRemark());
            statement.setString(8, overtimeApp.getReason());
            statement.setString(9, overtimeApp.getId());
            statement.executeUpdate();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void insertAppNo(String appID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT_APPNO);
        try {
            statement.setString(1, appID);
            statement.setString(2, new Timestamp(System.currentTimeMillis()).toString());
            statement.setString(3, new Timestamp(System.currentTimeMillis() + 36000000L).toString());
            statement.execute();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    @Override
    public Application getApplicationByID(String appID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_ID);
        OvertimeApp overtimeApp = new OvertimeApp();
        try {
            statement.setString(1, appID);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                Time endTime;
                overtimeApp.setId(appID);
                overtimeApp.setWorkday(rs.getTimestamp(WORKDAY));
                Calendar calendar = Calendar.getInstance();
                Time startTime = rs.getTime(START_TIME);
                if (startTime != null) {
                    calendar.setTime(startTime);
                    overtimeApp.setStartHour(calendar.get(11));
                    overtimeApp.setStartMin(calendar.get(12));
                }
                if ((endTime = rs.getTime(END_TIME)) != null) {
                    calendar.setTime(endTime);
                    overtimeApp.setEndHour(calendar.get(11));
                    overtimeApp.setEndMin(calendar.get(12));
                }
                overtimeApp.setOvertimeHours(rs.getFloat(OVERTIME_HOURS));
                if (rs.getInt(COMP_DAY) == 0) {
                    overtimeApp.setComp(true);
                } else {
                    overtimeApp.setComp(false);
                }
                overtimeApp.setCompDay(rs.getTimestamp(COMP_DAY_DATE));
                overtimeApp.setReason(rs.getString(REASON));
                overtimeApp.setRemark(rs.getString(REMARKS));
            }
            OvertimeApp overtimeApp2 = overtimeApp;
            return overtimeApp2;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    @Override
    public void remove(String appID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_DELETE);
        try {
            statement.setString(1, appID);
            statement.execute();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }
}

