/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;

public class KeySeqDAO {
    public static final String SEQ = "SEQ";
    public static final String NAME = "NAME";
    private static ResourceManager locator = ResourceManager.getInstance();
    private static final String SQL_INSERT_SEQUENCER = "INSERT INTO KEYSEQ (NAME, SEQ) VALUES (?, 0) ";
    private static final String SQL_UPDATE_SEQUENCER = "UPDATE KEYSEQ SET SEQ = ? WHERE (NAME = ?) AND (SEQ < ?) ";
    private static final String SQL_GET_SEQUENCER = "SELECT SEQ FROM KEYSEQ WHERE NAME = ? ";

    public int next(String seqName) throws SQLException {
        Connection conn = locator.getConnection();
        this.init(conn, seqName);
        int seq = this.current(conn, seqName);
        int result = 0;
        while (result < 1) {
            ++seq;
            PreparedStatement statement = conn.prepareStatement(SQL_UPDATE_SEQUENCER);
            try {
                statement.setLong(1, seq);
                statement.setString(2, seqName);
                statement.setLong(3, seq);
                result = statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        return seq;
    }

    private void init(Connection conn, String seqName) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT_SEQUENCER);
        try {
            try {
                statement.setString(1, seqName);
                statement.executeUpdate();
            }
            catch (SQLException sQLException) {
                statement.close();
            }
        }
        finally {
            statement.close();
        }
    }

    private int current(Connection conn, String seqName) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(SQL_GET_SEQUENCER);
        try {
            statement.setString(1, seqName);
            int seq = 0;
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(SEQ);
            }
            rs.close();
            int n = seq;
            return n;
        }
        finally {
            statement.close();
        }
    }
}

