/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.soap.UserManager;

public class ApplicationDAO {
    private static final String APPKIND_ID = "APPKIND_ID";
    private static final String USER_ID = "USER_ID";
    private static final String APP_DATE = "APP_DATE";
    private static ResourceManager locator = ResourceManager.getInstance();
    private static final String SQL_INSERT = "insert into APPLICATION (APP_ID, APPKIND_ID, USER_ID) values (?,?,?) ";
    private static final String SQL_SELECT_BY_APP_ID = "select * from APPLICATION where APP_ID = ?";
    private static final String SQL_DELETE = "delete from APPLICATION where APP_ID = ?";
    private static final String SQL_UPDATE = "update APPLICATION set APP_DATE = ? where APP_ID = ?";

    public Application getApplicationByID(String appID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APP_ID);
        try {
            statement.setString(1, appID);
            ResultSet rs = statement.executeQuery();
            String appKindID = "";
            String userID = "";
            Timestamp appDate = null;
            while (rs.next()) {
                appKindID = rs.getString(APPKIND_ID);
                userID = rs.getString(USER_ID);
                appDate = rs.getTimestamp(APP_DATE);
            }
            ApplicationDAO appKindDao = DAOFactory.getApplicationDAOFromAppKindID(appKindID);
            Application app = appKindDao.getApplicationByID(appID);
            AppKind appKind = DAOFactory.getAppKindDAO().getAppKindFromID(appKindID);
            app.setKind(appKind);
            app.setUserid(userID);
            app.setDate(appDate);
            UserManager umr = SingletonServices.getInstance().getUserManager();
            app.setUser(umr.getUser(userID));
            Application application = app;
            return application;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void updateApplication(Application app) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE);
        try {
            statement.setTimestamp(1, app.getDate());
            statement.setString(2, app.getId());
            statement.executeUpdate();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void insert(String appID, String appKindID, String userID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT);
        try {
            statement.setString(1, appID);
            statement.setString(2, appKindID);
            statement.setString(3, userID);
            statement.execute();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void remove(String appID) throws Exception {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction appTrans = appTransDao.getAppTransactionByAppIDBlockID(appID, 0);
        String appKindID = appTrans.getAppKindID();
        ApplicationDAO appDao = DAOFactory.getApplicationDAOFromAppKindID(appKindID);
        appDao.remove(appID);
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_DELETE);
        try {
            statement.setString(1, appID);
            statement.execute();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }
}

