/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppKindDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager;
import jp.co.argo21.nautica.workflow.soap.RoleManager;
import jp.co.argo21.nautica.workflow.soap.UserManager;
import jp.co.argo21.nautica.workflow.soap.message.Organization;
import jp.co.argo21.nautica.workflow.soap.message.Role;
import jp.co.argo21.nautica.workflow.soap.message.User;

public class AppTransactionDAO {
    public static final String APP_ID = "APP_ID";
    public static final String APPROVE_ACCOUNT_ID = "APPROVE_ACCOUNT_ID";
    public static final String APPKIND_ID = "APPKIND_ID";
    public static final String APP_STATUS = "APP_STATUS";
    public static final String APP_USER_ID = "APP_USER_ID";
    public static final String APP_ROLE_ID = "APP_ROLE_ID";
    public static final String COMMENT = "COMMENT";
    public static final String DATE = "DATE";
    private static final String KACHO_ROLE = "KACHO_ROLE";
    private static final String BUCHO_ROLE = "BUCHO_ROLE";
    public static final String JINJI_KACHO_ROLE = "JINJI_KACHO_ROLE";
    public static final String JINJI_BUCHO_ROLE = "JINJI_BUCHO_ROLE";
    public static final String JINJI_ROLE = "JINJI_ROLE";
    private static ResourceManager locator = ResourceManager.getInstance();
    private static final String SQL_INSERT_FOR_OVERTIME = "insert into APPTRANSACTION (APP_ID, APPROVE_ACCOUNT_ID, APPKIND_ID, APP_STATUS, APP_USER_ID, APP_ROLE_ID) values (?,?,?,?,?,?) ";
    private static final String SQL_SELECT_BY_APP_ID = "select * from APPTRANSACTION where APP_ID = ?";
    private static final String SQL_SELECT_BY_APPID_AND_USERID = "select * from APPTRANSACTION where APP_ID = ? and APP_USER_ID = ?";
    private static final String SQL_SELECT_BY_APPID_AND_ROLEID = "select * from APPTRANSACTION where APP_ID = ? and APP_ROLE_ID = ?";
    private static final String SQL_SELECT_BY_APPID_AND_ACCOUNT_ID = "select * from APPTRANSACTION where APP_ID = ? and APPROVE_ACCOUNT_ID = ?";
    private static final String SQL_SELECT_BY_USER_ID = "select * from APPTRANSACTION where APP_USER_ID = ?";
    private static final String SQL_SELECT_BY_ROLE_ID = "select * from APPTRANSACTION where APP_ROLE_ID = ? AND APP_USER_ID = ''";
    private static final String SQL_SELECT_FOR_CONTINUE = "select * from APPTRANSACTION A  where A.APP_ID = ? and A.APPROVE_ACCOUNT_ID = 0 and A.APP_USER_ID = ? and A.APP_STATUS = '\u5f85\u3061' union select B.* from APPTRANSACTION A join APPTRANSACTION B on A.APP_ID = B.APP_ID where A.APP_ID = ? and A.APPROVE_ACCOUNT_ID = 0 and A.APP_USER_ID = ? and B.APP_ID = ? and B.APP_STATUS = '\u5dee\u3057\u623b\u3057'";
    private static final String SQL_UPDATE = "update APPTRANSACTION set APP_STATUS = ?, APP_USER_ID = ?, APP_ROLE_ID = ?, COMMENT = ?, DATE = ?where APP_ID = ? and APPROVE_ACCOUNT_ID = ?";
    private static final String SQL_UPDATE_STATUS = "update APPTRANSACTION set APP_STATUS = ?where APP_ID = ? and APPROVE_ACCOUNT_ID = ?";
    private static final String SQL_DELETE = "delete from APPTRANSACTION where APP_ID = ?";

    public void remove(String appID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_DELETE);
        try {
            statement.setString(1, appID);
            statement.execute();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void insertForOverTime(String appID, String appKindID, String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT_FOR_OVERTIME);
        try {
            AppKindDAO appKindDao = DAOFactory.getAppKindDAO();
            int approveAccount = appKindDao.getApproveAccount(appKindID);
            int confirmAccount = appKindDao.getConfirmAccount(appKindID);
            List approvers = new ArrayList();
            approvers = this.getApprovalID(userID);
            int i = 0;
            while (i < approveAccount) {
                statement.setString(1, appID);
                statement.setInt(2, i);
                statement.setString(3, appKindID);
                if (i == 0) {
                    statement.setString(4, "\u5f85\u3061");
                    statement.setString(5, userID);
                    statement.setString(6, "");
                } else if (i == 1) {
                    statement.setString(4, "\u672a\u9054");
                    statement.setString(5, (String)approvers.get(0));
                    statement.setString(6, "");
                } else if (i == 2) {
                    statement.setString(4, "\u672a\u9054");
                    statement.setString(5, (String)approvers.get(1));
                    statement.setString(6, "");
                } else if (i == 3) {
                    statement.setString(4, "\u672a\u9054");
                    statement.setString(5, "");
                    statement.setString(6, (String)approvers.get(2));
                }
                statement.execute();
                ++i;
            }
            List confirmers = new ArrayList();
            confirmers = this.getConfirmID(userID);
            int i2 = approveAccount;
            while (i2 < approveAccount + confirmAccount) {
                statement.setString(1, appID);
                statement.setInt(2, i2);
                statement.setString(3, appKindID);
                if (i2 == 4) {
                    statement.setString(4, "\u540c\u5831");
                    statement.setString(5, (String)confirmers.get(0));
                    statement.setString(6, "");
                } else if (i2 == 5) {
                    statement.setString(4, "\u540c\u5831");
                    statement.setString(5, (String)confirmers.get(1));
                    statement.setString(6, "");
                }
                statement.execute();
                ++i2;
            }
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    private List getApprovalID(String userID) throws Exception {
        UserManager umr = SingletonServices.getInstance().getUserManager();
        OrganizationManager omr = SingletonServices.getInstance().getOrganizationManager();
        RoleManager rmr = SingletonServices.getInstance().getRoleManager();
        User user = umr.getUser(userID);
        List<Organization> orgs = omr.getOrganizationByUser(user);
        ArrayList<String> approvers = new ArrayList<String>();
        Role kachoRole = rmr.getRole(KACHO_ROLE);
        List<User> users = rmr.getUsersByRole(kachoRole);
        int i = 0;
        while (i < users.size()) {
            List<Organization> kachoOrgs = omr.getOrganizationByUser(users.get(i));
            if (kachoOrgs.get(0).getId().equals(orgs.get(0).getId())) {
                approvers.add(users.get(i).getId());
                break;
            }
            ++i;
        }
        Role buchoRole = rmr.getRole(BUCHO_ROLE);
        List<User> buchoUsers = rmr.getUsersByRole(buchoRole);
        Organization higherOrg = omr.getHigherOrganization(orgs.get(0));
        int i2 = 0;
        while (i2 < buchoUsers.size()) {
            List<User> higherUsers = omr.getAssignedUser(higherOrg);
            int j = 0;
            while (j < higherUsers.size()) {
                if (buchoUsers.get(i2).getId().equals(higherUsers.get(j).getId())) {
                    approvers.add(buchoUsers.get(i2).getId());
                    break;
                }
                ++j;
            }
            ++i2;
        }
        approvers.add(JINJI_ROLE);
        return approvers;
    }

    private List getConfirmID(String userID) throws Exception {
        ArrayList<String> confirmers = new ArrayList<String>();
        RoleManager rmr = SingletonServices.getInstance().getRoleManager();
        Role jinjiKachoRole = rmr.getRole(JINJI_KACHO_ROLE);
        List<User> jinjiKacho = rmr.getUsersByRole(jinjiKachoRole);
        confirmers.add(jinjiKacho.get(0).getId());
        Role jinjiBuchoRole = rmr.getRole(JINJI_BUCHO_ROLE);
        List<User> jinjiBucho = rmr.getUsersByRole(jinjiBuchoRole);
        confirmers.add(jinjiBucho.get(0).getId());
        return confirmers;
    }

    public AppTransaction[] getAppTransactionsByAppID(String appID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APP_ID);
        try {
            statement.setString(1, appID);
            ResultSet rs = statement.executeQuery();
            ArrayList<AppTransaction> result = new ArrayList<AppTransaction>();
            while (rs.next()) {
                AppTransaction kind = this.createAppTransFromRecord(rs);
                if (kind == null) continue;
                result.add(kind);
            }
            AppTransaction[] appTransactionArray = result.toArray(new AppTransaction[result.size()]);
            return appTransactionArray;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppTransaction[] getAppTransactionsByUserID(String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_USER_ID);
        try {
            statement.setString(1, userID);
            ResultSet rs = statement.executeQuery();
            ArrayList<AppTransaction> result = new ArrayList<AppTransaction>();
            while (rs.next()) {
                AppTransaction kind = this.createAppTransFromRecord(rs);
                if (kind == null) continue;
                result.add(kind);
            }
            AppTransaction[] appTransactionArray = result.toArray(new AppTransaction[result.size()]);
            return appTransactionArray;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppTransaction[] getAppTransactionsByRoleID(String roleID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_ROLE_ID);
        try {
            statement.setString(1, roleID);
            ResultSet rs = statement.executeQuery();
            ArrayList<AppTransaction> result = new ArrayList<AppTransaction>();
            while (rs.next()) {
                AppTransaction kind = this.createAppTransFromRecord(rs);
                if (kind == null) continue;
                result.add(kind);
            }
            AppTransaction[] appTransactionArray = result.toArray(new AppTransaction[result.size()]);
            return appTransactionArray;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppTransaction getAppTransactionByAppIDUserID(String appID, String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPID_AND_USERID);
        try {
            statement.setString(1, appID);
            statement.setString(2, userID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appt = null;
            while (rs.next()) {
                appt = this.createAppTransFromRecord(rs);
            }
            AppTransaction appTransaction = appt;
            return appTransaction;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppTransaction getAppTransactionByAppIDRoleID(String appID, String roleID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPID_AND_ROLEID);
        try {
            statement.setString(1, appID);
            statement.setString(2, roleID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appt = null;
            while (rs.next()) {
                appt = this.createAppTransFromRecord(rs);
            }
            AppTransaction appTransaction = appt;
            return appTransaction;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    private AppTransaction createAppTransFromRecord(ResultSet rs) throws SQLException {
        String appID = rs.getString(APP_ID);
        int approveAccountID = rs.getInt(APPROVE_ACCOUNT_ID);
        String appKindID = rs.getString(APPKIND_ID);
        String appStatus = rs.getString(APP_STATUS);
        String appUserID = rs.getString(APP_USER_ID);
        String appRoleID = rs.getString(APP_ROLE_ID);
        String comment = rs.getString(COMMENT);
        Timestamp date = rs.getTimestamp(DATE);
        AppTransaction appt = new AppTransaction();
        appt.setAppID(appID);
        appt.setApproveAccountID(approveAccountID);
        appt.setAppKindID(appKindID);
        appt.setAppUserID(appUserID);
        appt.setAppRoleID(appRoleID);
        appt.setAppStatus(appStatus);
        appt.setComment(comment);
        appt.setDate(date);
        AppKind appKindFromID = DAOFactory.getAppKindDAO().getAppKindFromID(appKindID);
        appt.setAppkind(appKindFromID);
        return appt;
    }

    public AppTransaction getAppTransactionForContinue(String appID, String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_FOR_CONTINUE);
        try {
            statement.setString(1, appID);
            statement.setString(2, userID);
            statement.setString(3, appID);
            statement.setString(4, userID);
            statement.setString(5, appID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appTrans = null;
            while (rs.next()) {
                appTrans = this.createAppTransFromRecord(rs);
            }
            AppTransaction appTransaction = appTrans;
            return appTransaction;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void updateAppTransaction(AppTransaction appTrans) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE);
        try {
            statement.setString(1, appTrans.getAppStatus());
            statement.setString(2, appTrans.getAppUserID());
            statement.setString(3, appTrans.getAppRoleID());
            statement.setString(4, appTrans.getComment());
            statement.setTimestamp(5, appTrans.getDate());
            statement.setString(6, appTrans.getAppID());
            statement.setInt(7, appTrans.getApproveAccountID());
            statement.executeUpdate();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public void updateStatus(AppTransaction appTrans) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE_STATUS);
        try {
            statement.setString(1, appTrans.getAppStatus());
            statement.setString(2, appTrans.getAppID());
            statement.setInt(3, appTrans.getApproveAccountID());
            statement.executeUpdate();
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppTransaction getAppTransactionByAppIDBlockID(String appID, int blockID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPID_AND_ACCOUNT_ID);
        try {
            statement.setString(1, appID);
            statement.setInt(2, blockID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appTras = null;
            while (rs.next()) {
                appTras = this.createAppTransFromRecord(rs);
            }
            AppTransaction appTransaction = appTras;
            return appTransaction;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }
}

