/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;

public class AppKindDAO {
    private static final String APPKIND_ID = "APPKIND_ID";
    private static final String APPKIND_NAME = "APPKIND_NAME";
    private static final String ROLE_ID = "ROLE_ID";
    private static final String APP_TABLE_NAME = "APP_TABLE_NAME";
    private static final String APPROVE_ACCOUNT = "APPROVE_ACCOUNT";
    private static final String CONFIRM_ACCOUNT = "CONFIRM_ACCOUNT";
    private static ResourceManager locator = ResourceManager.getInstance();
    private static final String SQL_SELECT_APPROVAL_ACCOUNT = "select APPROVE_ACCOUNT from APPKIND where APPKIND_ID = ?";
    private static final String SQL_SELECT_CONFIRM_ACCOUNT = "select CONFIRM_ACCOUNT from APPKIND where APPKIND_ID = ?";
    private static final String SQL_SELECT_BY_ROLE = "select * from APPKIND where ROLE_ID = ?";
    private static final String SQL_SELECT_BY_APPKIND_ID = "select * from APPKIND where APPKIND_ID = ?";

    public int getApproveAccount(String appKindID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_APPROVAL_ACCOUNT);
        try {
            statement.setString(1, appKindID);
            ResultSet rs = statement.executeQuery();
            int approvalAccount = 0;
            while (rs.next()) {
                approvalAccount = rs.getInt(1);
            }
            int n = approvalAccount;
            return n;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public int getConfirmAccount(String appKindID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_CONFIRM_ACCOUNT);
        try {
            statement.setString(1, appKindID);
            ResultSet rs = statement.executeQuery();
            int confirmAccount = 0;
            while (rs.next()) {
                confirmAccount = rs.getInt(1);
            }
            int n = confirmAccount;
            return n;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppKind[] listAppKindByRole(String roleID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_ROLE);
        try {
            statement.setString(1, roleID);
            ResultSet rs = statement.executeQuery();
            ArrayList<AppKind> result = new ArrayList<AppKind>();
            while (rs.next()) {
                AppKind kind = this.createAppKindFromRecord(rs);
                if (kind == null) continue;
                result.add(kind);
            }
            AppKind[] appKindArray = result.toArray(new AppKind[result.size()]);
            return appKindArray;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    public AppKind getAppKindFromID(String appKindID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPKIND_ID);
        AppKind appKind = null;
        try {
            statement.setString(1, appKindID);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                appKind = this.createAppKindFromRecord(rs);
            }
            AppKind appKind2 = appKind;
            return appKind2;
        }
        finally {
            locator.closeConnection(conn, statement);
        }
    }

    private AppKind createAppKindFromRecord(ResultSet rs) throws SQLException {
        String appkindID = rs.getString(APPKIND_ID);
        String appkindName = rs.getString(APPKIND_NAME);
        String roleID = rs.getString(ROLE_ID);
        String appTableName = rs.getString(APP_TABLE_NAME);
        int approveAccount = rs.getInt(APPROVE_ACCOUNT);
        int confirmAccount = rs.getInt(CONFIRM_ACCOUNT);
        AppKind kind = new AppKind();
        kind.setAppkindID(appkindID);
        kind.setAppkindName(appkindName);
        kind.setRoleID(roleID);
        kind.setAppTableName(appTableName);
        kind.setApproveAccount(approveAccount);
        kind.setConfirmAccount(confirmAccount);
        return kind;
    }
}

