/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.sample.util.StringUtil;
import jp.co.argo21.nautica.workflow.sample.util.WebServiceUtil;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager;
import jp.co.argo21.nautica.workflow.soap.RoleManager;
import jp.co.argo21.nautica.workflow.soap.UserManager;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.Organization;
import jp.co.argo21.nautica.workflow.soap.message.Process;
import jp.co.argo21.nautica.workflow.soap.message.Role;
import jp.co.argo21.nautica.workflow.soap.message.User;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

public class ShowApplication
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        ResourceManager rm = ResourceManager.getInstance();
        User user = (User)session.getAttribute("user");
        String sessionID = (String)session.getAttribute("sessionID");
        ServletContext context = this.getServletContext();
        RequestDispatcher dispatcher = null;
        String path = req.getParameter("screen");
        try {
            if (path.equals("Menu") || path.equals("AppState")) {
                String aim = req.getParameter("aim");
                List<Application> app = null;
                if (aim.equals("APPROVE")) {
                    app = this.getApprovalList(user, sessionID);
                } else if (aim.equals("CONFIRM")) {
                    app = this.getConfirmList(sessionID, user);
                } else if (aim.equals("WAIT")) {
                    app = this.getAllList(user, sessionID);
                }
                if (app.size() == 0) {
                    req.setAttribute("errMsg", (Object)rm.getValue("error.nolist"));
                } else {
                    req.setAttribute("app", app);
                }
                session.setAttribute("aim", (Object)aim);
                dispatcher = context.getRequestDispatcher("/AppList.jsp");
            } else if (path.equals("AppList")) {
                String appID = req.getParameter("appID");
                OvertimeApp overtime = (OvertimeApp)DAOFactory.getApplicationDAO().getApplicationByID(appID);
                OrganizationManager orgManager = ServiceAccessor.getInstance().getOrganizationManager();
                List<Organization> orgList = orgManager.getOrganizationByUser(user);
                Organization org = orgList.get(0);
                req.setAttribute("overtime", (Object)overtime);
                req.setAttribute("org", (Object)org);
                String aim = (String)session.getAttribute("aim");
                if (aim.equals("APPROVE") || aim.equals("CONFIRM")) {
                    dispatcher = context.getRequestDispatcher("/App.jsp");
                } else if (aim.equals("WAIT")) {
                    AppTransaction[] appTransArray = this.getApprovalState(appID);
                    req.setAttribute("appTran", (Object)appTransArray);
                    dispatcher = context.getRequestDispatcher("/AppState.jsp");
                }
            }
        }
        catch (Exception e) {
            session.invalidate();
            req.setAttribute("errMsg", (Object)e.toString());
            req.setAttribute("err", (Object)e.getStackTrace());
            dispatcher = context.getRequestDispatcher("/FatalError.jsp");
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private List<Application> getApprovalList(User user, String sessionID) throws Exception {
        ArrayList appTransList = new ArrayList();
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction[] apptsByUser = appTransDao.getAppTransactionsByUserID(user.getId());
        appTransList.addAll(Arrays.asList(apptsByUser));
        RoleManager roleManager = ServiceAccessor.getInstance().getRoleManager();
        List<Role> roleList = roleManager.getAttachedRoles2(user);
        ArrayList<String> roleIDList = new ArrayList<String>();
        for (Role role : roleList) {
            roleIDList.add(role.getId());
        }
        if (roleIDList.contains("JINJI_ROLE") && !roleIDList.contains("JINJI_BUCHO_ROLE") && !roleIDList.contains("JINJI_KACHO_ROLE")) {
            AppTransaction[] apptsByRole = appTransDao.getAppTransactionsByRoleID("JINJI_ROLE");
            appTransList.addAll(Arrays.asList(apptsByRole));
        }
        ArrayList<String> appIDList = new ArrayList<String>();
        for (AppTransaction appTrans : appTransList) {
            if (appTrans == null || !appTrans.getAppStatus().equals("\u5f85\u3061") || appIDList.contains(appTrans.getAppID())) continue;
            appIDList.add(appTrans.getAppID());
        }
        WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> state = WebServiceUtil.createEqualAttributeFilter("STATUS", "APPROVAL_WAIT");
        List<WorkItem> items = wiHandler.getWorkItems(sessionID, state);
        ArrayList<String> wiAppIDList = new ArrayList<String>();
        for (WorkItem witem : items) {
            String wid = witem.getID();
            String appID = wiHandler.getWorkItemAttributeValue(sessionID, wid, "APPLICATION_NO").getValue();
            wiAppIDList.add(appID);
        }
        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
        ArrayList<Application> appList = new ArrayList<Application>();
        for (String appID : appIDList) {
            if (!wiAppIDList.contains(appID)) continue;
            Application app = appDao.getApplicationByID(appID);
            appList.add(app);
        }
        return appList;
    }

    private List<Application> getConfirmList(String sessionID, User user) throws Exception {
        WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> state = WebServiceUtil.createEqualAttributeFilter("STATUS", "CONFIRM_WAIT");
        List<WorkItem> items = wiHandler.getWorkItems(sessionID, state);
        ArrayList<Application> appList = new ArrayList<Application>();
        for (WorkItem item : items) {
            String wid = item.getID();
            String appID = wiHandler.getWorkItemAttributeValue(sessionID, wid, "APPLICATION_NO").getValue();
            Application app = DAOFactory.getApplicationDAO().getApplicationByID(appID);
            appList.add(app);
        }
        return appList;
    }

    private List<Application> getAllList(User user, String sessionID) throws Exception {
        ArrayList appIDList = new ArrayList();
        AppTransaction[] apptsByUser = DAOFactory.getAppTransactionDAO().getAppTransactionsByUserID(user.getId());
        this.addAppID(appIDList, apptsByUser);
        RoleManager roleManager = ServiceAccessor.getInstance().getRoleManager();
        List<Role> roleList = roleManager.getAttachedRoles2(user);
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        for (Role role : roleList) {
            AppTransaction[] apptsByRole = appTransDao.getAppTransactionsByRoleID(role.getId());
            this.addAppID(appIDList, apptsByRole);
        }
        WorkflowEngineHandler wfEngineHandler = ServiceAccessor.getInstance().getWfEngineHandler();
        List<Filter> stateFilter = WebServiceUtil.createEqualStateFilter("ProcessState", "open.running");
        List<Process> processes = wfEngineHandler.getProcesses(sessionID, stateFilter);
        ArrayList<String> processAppID = new ArrayList<String>();
        for (Process process : processes) {
            processAppID.add(process.getName());
        }
        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
        ArrayList<Application> appList = new ArrayList<Application>();
        for (String appID : appIDList) {
            if (!processAppID.contains(appID)) continue;
            Application app = appDao.getApplicationByID(appID);
            appList.add(app);
        }
        return appList;
    }

    private AppTransaction[] getApprovalState(String appID) throws Exception {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction[] appTransArray = appTransDao.getAppTransactionsByAppID(appID);
        UserManager userManager = ServiceAccessor.getInstance().getUserManager();
        AppTransaction[] appTransactionArray = appTransArray;
        int n = appTransArray.length;
        int n2 = 0;
        while (n2 < n) {
            AppTransaction appTrans = appTransactionArray[n2];
            String userID = appTrans.getAppUserID();
            if (userID != null && !userID.equals("")) {
                String userName = StringUtil.toFullName(userManager.getUser(userID));
                appTrans.setAppUserID(userName);
            } else {
                String roleID = appTrans.getAppRoleID();
                if ("JINJI_ROLE".equals(roleID)) {
                    appTrans.setAppUserID("\u4eba\u4e8b\u90e8");
                }
            }
            ++n2;
        }
        return appTransArray;
    }

    private void addAppID(List list, AppTransaction[] appts) throws Exception {
        int i = 0;
        while (i < appts.length) {
            String id = appts[i].getAppID();
            AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
            AppTransaction appTrans = appTransDao.getAppTransactionByAppIDBlockID(id, 0);
            if (!list.contains(id) && "\u7533\u8acb".equals(appTrans.getAppStatus())) {
                list.add(id);
            }
            ++i;
        }
    }
}

