/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StringUtil;
import jp.co.argo21.nautica.workflow.sample.util.WebServiceUtil;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.User;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

public class RestartInput
extends HttpServlet
implements Servlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        ResourceManager rm = ResourceManager.getInstance();
        String sessionID = (String)session.getAttribute("sessionID");
        User user = (User)session.getAttribute("user");
        ServletContext context = this.getServletContext();
        RequestDispatcher dispatcher = null;
        String path = req.getParameter("screen");
        try {
            if (path.equals("Menu")) {
                List<AppTransaction> appTrans = this.getApplyWaitList(sessionID, user);
                if (appTrans.size() == 0) {
                    req.setAttribute("errMsg", (Object)rm.getValue("error.nolist"));
                } else {
                    req.setAttribute("appTrans", appTrans);
                }
                dispatcher = context.getRequestDispatcher("/ApplyWaitList.jsp");
            } else if (path.equals("ApplyWaitList")) {
                String appID = req.getParameter("appID");
                OvertimeApp overtime = this.getOvertimeApp(appID);
                req.setAttribute("overtimeApp", (Object)overtime);
                dispatcher = req.getRequestDispatcher("/ApplyInput.jsp");
            }
        }
        catch (Exception e) {
            session.invalidate();
            req.setAttribute("errMsg", (Object)e.toString());
            req.setAttribute("err", (Object)e.getStackTrace());
            dispatcher = context.getRequestDispatcher("/FatalError.jsp");
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private List<AppTransaction> getApplyWaitList(String sessionID, User user) throws Exception {
        WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> stateFilter = WebServiceUtil.createEqualAttributeFilter("STATUS", "APPLY_WAIT");
        List<WorkItem> itemList = wiHandler.getWorkItems(sessionID, stateFilter);
        WorkflowEngineHandler wfEngineHandler = ServiceAccessor.getInstance().getWfEngineHandler();
        ArrayList<AppTransaction> appTransList = new ArrayList<AppTransaction>();
        for (WorkItem item : itemList) {
            String pid = item.getProcessID();
            Attribute attr = wfEngineHandler.getProcessAttributeValue(sessionID, pid, "APPLICATION_NO");
            AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
            AppTransaction appTrans = appTransDao.getAppTransactionForContinue(attr.getValue(), user.getId());
            if (appTrans == null) continue;
            String appUserID = appTrans.getAppUserID();
            User appUser = SingletonServices.getInstance().getUserManager().getUser(appUserID);
            appTrans.setAppUserID(StringUtil.toFullName(appUser));
            appTransList.add(appTrans);
        }
        return appTransList;
    }

    private OvertimeApp getOvertimeApp(String appID) throws Exception {
        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
        Application app = appDao.getApplicationByID(appID);
        return (OvertimeApp)app;
    }
}

