/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppKindDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.model.dao.OvertimeAppDAO;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.sample.util.StringUtil;
import jp.co.argo21.nautica.workflow.sample.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.sample.util.WebServiceUtil;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager;
import jp.co.argo21.nautica.workflow.soap.RoleManager;
import jp.co.argo21.nautica.workflow.soap.ServiceAccessorException;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowException;
import jp.co.argo21.nautica.workflow.soap.message.Organization;
import jp.co.argo21.nautica.workflow.soap.message.Role;
import jp.co.argo21.nautica.workflow.soap.message.User;

public class PrepareApply
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        ResourceManager rm = ResourceManager.getInstance();
        String sessionID = (String)session.getAttribute("sessionID");
        User user = (User)session.getAttribute("user");
        ServletContext context = this.getServletContext();
        RequestDispatcher dispatcher = null;
        try {
            String path = req.getParameter("screen");
            if (path.equals("Menu")) {
                List<AppKind> appKindList = this.getAppKindList(user);
                if (appKindList.size() == 0) {
                    req.setAttribute("errMsg", (Object)rm.getValue("error.noapp"));
                } else {
                    req.setAttribute("appKindList", appKindList);
                }
                dispatcher = context.getRequestDispatcher("/AppKindList.jsp");
            } else if (path.equals("AppKindList")) {
                String appKindID = req.getParameter("appKindID");
                OvertimeApp application = this.createApplication(appKindID, sessionID, user);
                req.setAttribute("overtimeApp", (Object)application);
                dispatcher = context.getRequestDispatcher("/ApplyInput.jsp");
            }
        }
        catch (Exception e) {
            session.invalidate();
            req.setAttribute("errMsg", (Object)e.toString());
            req.setAttribute("err", (Object)e.getStackTrace());
            dispatcher = context.getRequestDispatcher("/FatalError.jsp");
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private List<AppKind> getAppKindList(User user) throws ServiceAccessorException, WorkflowException, SQLException {
        RoleManager roleManager = ServiceAccessor.getInstance().getRoleManager();
        List<Role> roles = roleManager.getAttachedRoles2(user);
        AppKind[] tempAppKind = null;
        ArrayList<AppKind> availableAppKind = new ArrayList<AppKind>();
        AppKindDAO appKindDao = DAOFactory.getAppKindDAO();
        for (Role role : roles) {
            tempAppKind = appKindDao.listAppKindByRole(role.getId());
            if (tempAppKind.length <= 0) continue;
            AppKind[] appKindArray = tempAppKind;
            int n = tempAppKind.length;
            int n2 = 0;
            while (n2 < n) {
                AppKind kind = appKindArray[n2];
                availableAppKind.add(kind);
                ++n2;
            }
        }
        return availableAppKind;
    }

    private OvertimeApp createApplication(String appKindID, String sessionID, User user) throws Exception {
        String appID = UniqueKeyGenerator.generate(appKindID);
        String userID = user.getId();
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        appTransDao.insertForOverTime(appID, appKindID, userID);
        OvertimeAppDAO overtimeDao = (OvertimeAppDAO)DAOFactory.getApplicationDAOFromAppKindID(appKindID);
        overtimeDao.insertAppNo(appID);
        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
        appDao.insert(appID, appKindID, userID);
        WorkflowEngineHandler wfEngineHandler = ServiceAccessor.getInstance().getWfEngineHandler();
        String pid = wfEngineHandler.createProcess(sessionID, "Overtime-0", appID);
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "STATUS", "APPLY_WAIT");
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "APPLICATION_NO", appID);
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "APPLICANT_ID", user.getId());
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "APPLICANT_NAME", StringUtil.toFullName(user));
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "APPLICATION_TYPE_CODE", appKindID);
        OrganizationManager orgManager = ServiceAccessor.getInstance().getOrganizationManager();
        List<Organization> org = orgManager.getOrganizationByUser(user);
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "ORGANIZATION_CODE", org.get(0).getId());
        AppKindDAO appKindDao = DAOFactory.getAppKindDAO();
        AppKind appkind = appKindDao.getAppKindFromID(appKindID);
        WebServiceUtil.assignProcessAttribute(sessionID, pid, "APPLICATION_TYPE_NAME", appkind.getAppkindName());
        wfEngineHandler.startProcess(sessionID, pid);
        OvertimeApp application = (OvertimeApp)appDao.getApplicationByID(appID);
        return application;
    }
}

