/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.soap.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.soap.OrganizationManager;
import jp.co.argo21.nautica.workflow.soap.ServiceAccessorException;
import jp.co.argo21.nautica.workflow.soap.UserManager;
import jp.co.argo21.nautica.workflow.soap.WorkflowException;
import jp.co.argo21.nautica.workflow.soap.WorkflowServiceConnector;
import jp.co.argo21.nautica.workflow.soap.message.Organization;
import jp.co.argo21.nautica.workflow.soap.message.User;

public class Login
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        String userID = req.getParameter("userID");
        String password = req.getParameter("password");
        HttpSession session = req.getSession(true);
        ServletContext context = this.getServletContext();
        RequestDispatcher dispatcher = null;
        try {
            String sessionID = this.login(userID, password);
            User user = this.prepareUser(userID);
            Organization org = this.prepareOrganization(user);
            session.setAttribute("sessionID", (Object)sessionID);
            session.setAttribute("user", (Object)user);
            session.setAttribute("org", (Object)org);
            dispatcher = context.getRequestDispatcher("/Menu.jsp");
        }
        catch (ConnectionFailedException e) {
            req.setAttribute("errMsg", (Object)rm.getValue("error.login"));
            dispatcher = context.getRequestDispatcher("/Login.jsp");
        }
        catch (Exception e) {
            session.invalidate();
            req.setAttribute("errMsg", (Object)e.toString());
            req.setAttribute("err", (Object)e.getStackTrace());
            dispatcher = context.getRequestDispatcher("/FatalError.jsp");
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private String login(String userID, String password) throws ConnectionFailedException {
        WorkflowServiceConnector wfServiceConnector = ServiceAccessor.getInstance().getWfServiceConnector();
        String sessionID = wfServiceConnector.connect(userID, password);
        return sessionID;
    }

    private User prepareUser(String userID) throws WorkflowException, ServiceAccessorException {
        UserManager userManager = ServiceAccessor.getInstance().getUserManager();
        User user = userManager.getUser(userID);
        return user;
    }

    private Organization prepareOrganization(User user) throws WorkflowException, ServiceAccessorException {
        OrganizationManager orgManager = ServiceAccessor.getInstance().getOrganizationManager();
        Organization org = orgManager.getOrganizationByUser(user).get(0);
        return org;
    }
}

