/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.HtmlUtil;
import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.sample.util.WebServiceUtil;
import jp.co.argo21.nautica.workflow.soap.RoleManager;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.Role;
import jp.co.argo21.nautica.workflow.soap.message.User;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

public class Check
extends HttpServlet
implements Servlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        req.setCharacterEncoding("UTF-8");
        User user = (User)session.getAttribute("user");
        String sessionID = (String)session.getAttribute("sessionID");
        String appID = req.getParameter("appID");
        String pressedButton = req.getParameter("pressedButton");
        String preComment = req.getParameter("comment");
        String comment = HtmlUtil.sanitize(preComment);
        ServletContext context = this.getServletContext();
        RequestDispatcher dispatcher = null;
        try {
            if (pressedButton.equals("\u627f\u8a8d")) {
                this.approve(sessionID, user, appID, comment);
            } else if (pressedButton.equals("\u5dee\u3057\u623b\u3057")) {
                this.retry(sessionID, user, appID, comment);
            } else if (pressedButton.equals("\u5426\u8a8d")) {
                this.deny(sessionID, user, appID, comment);
            } else if (pressedButton.equals("\u78ba\u8a8d")) {
                this.confirm(sessionID, user, appID);
            }
            req.setAttribute("appID", (Object)appID);
            req.setAttribute("pressedButton", (Object)pressedButton);
            context = this.getServletContext();
            dispatcher = context.getRequestDispatcher("/Complete.jsp");
        }
        catch (Exception e) {
            session.invalidate();
            req.setAttribute("errMsg", (Object)e.toString());
            req.setAttribute("err", (Object)e.getStackTrace());
            dispatcher = context.getRequestDispatcher("/FatalError.jsp");
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private void approve(String sessionID, User user, String appID, String comment) throws Exception {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appID);
        AppTransaction appTrans = null;
        AppTransaction nextAppTrans = null;
        int i = 0;
        while (i < appTranses.length) {
            String status = appTranses[i].getAppStatus();
            if ("\u5f85\u3061".equals(status)) {
                appTrans = appTranses[i];
                if (i >= appTranses.length - 1) break;
                nextAppTrans = appTranses[i + 1];
                break;
            }
            ++i;
        }
        if (appTrans != null) {
            this.updateAppTransaction(appTrans, "\u627f\u8a8d", user, comment);
        }
        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
        Application app = appDao.getApplicationByID(appID);
        int approveAccount = app.getKind().getApproveAccount();
        if (nextAppTrans != null && nextAppTrans.getApproveAccountID() < approveAccount) {
            nextAppTrans.setAppStatus("\u5f85\u3061");
            appTransDao.updateStatus(nextAppTrans);
        }
        WorkItemHandler wfWorkitemHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> appIDFilter = WebServiceUtil.createEqualAttributeFilter("APPLICATION_NO", appID);
        List<WorkItem> workItems = wfWorkitemHandler.getWorkItems(sessionID, appIDFilter);
        String wid = workItems.get(0).getID();
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "APPROVAL_RESULT", "ACK");
        int approveCount = app.getKind().getApproveAccount();
        if (approveCount == appTrans.getApproveAccountID() + 1) {
            WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "STATUS", "CONFIRM_WAIT");
        }
        wfWorkitemHandler.completeWorkItem(sessionID, wid);
    }

    private void retry(String sessionID, User user, String appID, String comment) throws Exception {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction appTrans = this.getSmallestAppTrans(appID);
        if (appTrans != null) {
            this.updateAppTransaction(appTrans, "\u5dee\u3057\u623b\u3057", user, comment);
            AppTransaction applyTrans = appTransDao.getAppTransactionByAppIDBlockID(appID, 0);
            applyTrans.setAppStatus("\u5f85\u3061");
            appTransDao.updateAppTransaction(applyTrans);
        }
        WorkItemHandler wiHandlerler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> appIDFilter = WebServiceUtil.createEqualAttributeFilter("APPLICATION_NO", appID);
        List<WorkItem> workItems = wiHandlerler.getWorkItems(sessionID, appIDFilter);
        String wid = workItems.get(0).getID();
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "APPROVAL_RESULT", "RETRY");
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "STATUS", "APPLY_WAIT");
        wiHandlerler.completeWorkItem(sessionID, wid);
    }

    private void deny(String sessionID, User user, String appID, String comment) throws Exception {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction appTrans = this.getSmallestAppTrans(appID);
        if (appTrans != null) {
            this.updateAppTransaction(appTrans, "\u5426\u8a8d", user, comment);
        }
        WorkItemHandler wfWorkitemHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> appIDFilter = WebServiceUtil.createEqualAttributeFilter("APPLICATION_NO", appID);
        List<WorkItem> workItems = wfWorkitemHandler.getWorkItems(sessionID, appIDFilter);
        String wid = workItems.get(0).getID();
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "APPROVAL_RESULT", "NACK");
        wfWorkitemHandler.completeWorkItem(sessionID, wid);
    }

    private void confirm(String sessionID, User user, String appID) throws Exception {
        WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> appIDFilter = WebServiceUtil.createEqualAttributeFilter("APPLICATION_NO", appID);
        List<WorkItem> workItems = wiHandler.getWorkItems(sessionID, appIDFilter);
        String wid = workItems.get(0).getID();
        RoleManager roleManager = ServiceAccessor.getInstance().getRoleManager();
        List<Role> attachedRoles = roleManager.getAttachedRoles2(user);
        Attribute attr = new Attribute();
        attr.setType(3);
        for (Role role : attachedRoles) {
            if (role.getId().equals("JINJI_KACHO_ROLE")) {
                attr.setName("NOTIFICATION_JINJI_KACHO");
                continue;
            }
            if (!role.getId().equals("JINJI_BUCHO_ROLE")) continue;
            attr.setName("NOTIFICATION_JINJI_BUCHO");
        }
        attr.setValue("true");
        wiHandler.assignWorkItemAttribute(sessionID, wid, attr);
        wiHandler.completeWorkItem(sessionID, wid);
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction appTrans = appTransDao.getAppTransactionByAppIDUserID(appID, user.getId());
        appTrans.setAppStatus("\u78ba\u8a8d");
        appTransDao.updateStatus(appTrans);
    }

    private AppTransaction getSmallestAppTrans(String appID) throws Exception {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appID);
        AppTransaction appTrans = null;
        int i = 0;
        while (i < appTranses.length) {
            String status = appTranses[i].getAppStatus();
            if ("\u5f85\u3061".equals(status)) {
                appTrans = appTranses[i];
                break;
            }
            ++i;
        }
        return appTrans;
    }

    private void updateAppTransaction(AppTransaction appTrans, String state, User user, String comment) throws SQLException {
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        appTrans.setAppStatus(state);
        appTrans.setAppUserID(user.getId());
        appTrans.setComment(comment);
        appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        appTransDao.updateAppTransaction(appTrans);
    }
}

