/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.sample.control;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.model.dao.OvertimeAppDAO;
import jp.co.argo21.nautica.workflow.sample.util.HtmlUtil;
import jp.co.argo21.nautica.workflow.sample.util.ServiceAccessor;
import jp.co.argo21.nautica.workflow.sample.util.Validator;
import jp.co.argo21.nautica.workflow.sample.util.ValidatorException;
import jp.co.argo21.nautica.workflow.sample.util.WebServiceUtil;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.User;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

public class Apply
extends HttpServlet {
    private static final int FIRST_APPROVER = 1;
    private static final int APPLICANT = 0;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher dispatcher;
        block13: {
            HttpSession session = req.getSession(true);
            req.setCharacterEncoding("UTF-8");
            User user = (User)session.getAttribute("user");
            String appKindID = req.getParameter("appKindID");
            String sessionID = (String)session.getAttribute("sessionID");
            String path = req.getParameter("screen");
            String pressedButton = req.getParameter("pressedButton");
            String appID = req.getParameter("appID");
            ServletContext context = this.getServletContext();
            dispatcher = null;
            try {
                if (path.equals("ApplyInput")) {
                    if (pressedButton.equals("\u78ba\u8a8d")) {
                        OvertimeApp rawContent = this.toOvertimeApp(req);
                        OvertimeApp content = HtmlUtil.sanitize(rawContent);
                        try {
                            Validator.validate(content);
                        }
                        catch (ValidatorException e) {
                            List<String> errMsgs = e.getErrList();
                            req.setAttribute("errMsg", errMsgs);
                            req.setAttribute("overtimeApp", (Object)content);
                            dispatcher = context.getRequestDispatcher("/ApplyInput.jsp");
                            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                            return;
                        }
                        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
                        appDao.updateApplication(content);
                        OvertimeAppDAO overtimeDao = (OvertimeAppDAO)DAOFactory.getApplicationDAOFromAppKindID(appKindID);
                        overtimeDao.updateApplication(content);
                        req.setAttribute("overtime", (Object)content);
                        session.setAttribute("applyDay", (Object)content.getDate());
                        dispatcher = context.getRequestDispatcher("/ConfirmApply.jsp");
                        break block13;
                    }
                    if (pressedButton.equals("\u30ad\u30e3\u30f3\u30bb\u30eb")) {
                        this.cancel(sessionID, user, appID);
                        dispatcher = context.getRequestDispatcher("/Menu.jsp");
                    }
                    break block13;
                }
                if (path.equals("ConfirmApply")) {
                    if (pressedButton.equals("\u7533\u8acb")) {
                        Timestamp applyDay = (Timestamp)session.getAttribute("applyDay");
                        this.apply(user, sessionID, appID, applyDay);
                        req.setAttribute("appID", (Object)appID);
                        dispatcher = context.getRequestDispatcher("/CompleteApply.jsp");
                    } else if (pressedButton.equals("\u8a02\u6b63")) {
                        OvertimeApp overtime = (OvertimeApp)DAOFactory.getApplicationDAO().getApplicationByID(appID);
                        req.setAttribute("overtimeApp", (Object)overtime);
                        dispatcher = context.getRequestDispatcher("/ApplyInput.jsp");
                    } else if (pressedButton.equals("\u30ad\u30e3\u30f3\u30bb\u30eb")) {
                        this.cancel(sessionID, user, appID);
                        dispatcher = context.getRequestDispatcher("/Menu.jsp");
                    }
                }
            }
            catch (Exception e) {
                session.invalidate();
                req.setAttribute("errMsg", (Object)e.toString());
                req.setAttribute("err", (Object)e.getStackTrace());
                dispatcher = context.getRequestDispatcher("/FatalError.jsp");
            }
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private void apply(User user, String sessionID, String appID, Timestamp applyday) throws Exception {
        AppTransaction[] appTransArray;
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        AppTransaction[] appTransactionArray = appTransArray = appTransDao.getAppTransactionsByAppID(appID);
        int n = appTransArray.length;
        int n2 = 0;
        while (n2 < n) {
            AppTransaction appTrans = appTransactionArray[n2];
            int approveAccountID = appTrans.getApproveAccountID();
            if (approveAccountID == 0) {
                appTrans.setAppStatus("\u7533\u8acb");
                appTrans.setAppUserID(user.getId());
                appTrans.setDate(applyday);
                appTransDao.updateAppTransaction(appTrans);
            } else if (approveAccountID == 1) {
                appTrans.setAppStatus("\u5f85\u3061");
                appTransDao.updateStatus(appTrans);
            }
            ++n2;
        }
        WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> appIDFilter = WebServiceUtil.createEqualAttributeFilter("APPLICATION_NO", appID);
        List<WorkItem> items = wiHandler.getWorkItems(sessionID, appIDFilter);
        String wid = items.get(0).getID();
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "APPLY_DATE", applyday.toString());
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "STATUS", "APPROVAL_WAIT");
        wiHandler.completeWorkItem(sessionID, wid);
    }

    private void cancel(String sessionID, User user, String appID) throws Exception {
        ApplicationDAO appDao = DAOFactory.getApplicationDAO();
        appDao.remove(appID);
        AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
        appTransDao.remove(appID);
        WorkItemHandler wiHandler = ServiceAccessor.getInstance().getWorkItemHandler();
        List<Filter> appIDFilter = WebServiceUtil.createEqualAttributeFilter("APPLICATION_NO", appID);
        List<WorkItem> items = wiHandler.getWorkItems(sessionID, appIDFilter);
        String wid = items.get(0).getID();
        WebServiceUtil.assignWorkItemAttribute(sessionID, wid, "APPLICATION_NO", "");
        wiHandler.completeWorkItem(sessionID, wid);
    }

    private OvertimeApp toOvertimeApp(HttpServletRequest req) throws SQLException {
        String appKindID = req.getParameter("appKindID");
        String appID = req.getParameter("appID");
        Calendar workCalendar = Calendar.getInstance();
        workCalendar.set(Integer.parseInt(req.getParameter("workdayYear")), Integer.parseInt(req.getParameter("workdayMonth")) - 1, Integer.parseInt(req.getParameter("workdayDay")));
        Timestamp workday = new Timestamp(workCalendar.getTimeInMillis());
        int startHour = Integer.parseInt(req.getParameter("startHour"));
        int startMin = Integer.parseInt(req.getParameter("startMin"));
        int endHour = Integer.parseInt(req.getParameter("endHour"));
        int endMin = Integer.parseInt(req.getParameter("endMin"));
        float overtimeHours = Float.parseFloat(req.getParameter("overtimeHours"));
        boolean isComp = Boolean.parseBoolean(req.getParameter("compDay"));
        Calendar compCalendar = Calendar.getInstance();
        compCalendar.set(Integer.parseInt(req.getParameter("compDayYear")), Integer.parseInt(req.getParameter("compDayMonth")) - 1, Integer.parseInt(req.getParameter("compDayDay")));
        Timestamp compDay = new Timestamp(compCalendar.getTimeInMillis());
        Timestamp applyday = new Timestamp(System.currentTimeMillis());
        AppKind appKind = DAOFactory.getAppKindDAO().getAppKindFromID(appKindID);
        OvertimeApp preContent = new OvertimeApp();
        preContent.setId(appID);
        preContent.setWorkday(workday);
        preContent.setStartHour(startHour);
        preContent.setStartMin(startMin);
        preContent.setEndHour(endHour);
        preContent.setEndMin(endMin);
        preContent.setOvertimeHours(overtimeHours);
        preContent.setReason(req.getParameter("reason"));
        preContent.setComp(isComp);
        preContent.setCompDay(compDay);
        preContent.setDate(applyday);
        preContent.setRemark(req.getParameter("remarks"));
        preContent.setKind(appKind);
        return preContent;
    }
}

