/* $Id: WorkflowAdminManager.java,v 1.1 2007/10/19 07:29:57 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import javax.swing.ActionMap;

import jp.co.argo21.nautica.commons.swing.ExceptionViewer;
import jp.co.argo21.nautica.commons.swing.HelpViewer;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.action.ActionNames;
import jp.co.argo21.nautica.tool.wfadm.action.ExceptionViewerAction;
import jp.co.argo21.nautica.tool.wfadm.action.ExitAction;
import jp.co.argo21.nautica.tool.wfadm.action.HelpAction;
import jp.co.argo21.nautica.tool.wfadm.action.OpenAction;
import jp.co.argo21.nautica.tool.wfadm.action.PreferencesAction;
import jp.co.argo21.nautica.tool.wfadm.action.RegisterDefinitionAction;
import jp.co.argo21.nautica.tool.wfadm.action.ShutdownAction;
import jp.co.argo21.nautica.tool.wfadm.action.VersionAction;
import jp.co.argo21.nautica.tool.wfadm.common.BusyDialog;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.pref.PreferenceManager;

/**
 * Nauticaワークフロー運用管理ツール全般の管理を行う。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class WorkflowAdminManager
{
	/** バンドルパス名 */
	private static final String BUNDLE_PATH
		= "jp.co.argo21.nautica.tool.wfadm.resources.messages";

	/** リソースマネージャ */
	private static ResourceManager resourceManager;
	/** メイン画面 */
	private static WorkflowAdminFrame mainFrame;
	/** 例外ビューア */
	private static ExceptionViewer exceptionViewer;
	/** バージョン画面 */
	private static VersionWindow versionWindow;
	/** ヘルプ画面 */
	private static HelpViewer helpViewer;
	/** アクションマップ */
	private static ActionMap actionMap;
	/** 処理待ちダイアログ */
	private static BusyDialog busyDialog;

	/**
	 * 起動処理を行う。
	 */
	public static void boot() throws Exception
	{
		resourceManager = new ResourceManager(BUNDLE_PATH);

		//スプラッシュ表示
		versionWindow = new VersionWindow();
		versionWindow.setVisible(true);

		//各マネージャの初期化
		PreferenceManager.create();
		
		//アクションマップの生成
		createActionMap();
		
		//スプラッシュ表示のための1.5秒間の無駄処理
		long t = System.currentTimeMillis() + 1500;
		while (System.currentTimeMillis() < t) { /* NOP */ }

		mainFrame = new WorkflowAdminFrame();
		exceptionViewer = new ExceptionViewer(mainFrame, false);
		helpViewer = new HelpViewer();
		busyDialog = new BusyDialog(mainFrame);
		mainFrame.setVisible(true);

		versionWindow.setVisible(false);
	}

	/**
	 * リソースマネージャを返す。
	 *
	 * @return	リソースマネージャ
	 */
	public static ResourceManager getResourceManager()
	{
		return resourceManager;
	}

	/**
	 * 例外ビューアに例外を設定する。
	 * 
	 * @param ex	任意の例外
	 */
	public static void setException(Exception ex)
	{
		exceptionViewer.setThrowable(ex);
	}

	/**
	 * 例外ビューアを返す。
	 * 
	 * @return 例外ビューア
	 */
	public static ExceptionViewer getExceptionViewer()
	{
		return exceptionViewer;
	}

	/**
	 * ヘルプ画面を返す。
	 * 
	 * @return ヘルプ画面
	 */
	public static HelpViewer getHelpViewer()
	{
		return helpViewer;
	}

	/**
	 * メイン画面を返す。
	 * 
	 * @return メイン画面
	 */
	public static WorkflowAdminFrame getMainFrame()
	{
		return mainFrame;
	}

	/**
	 * バージョン画面を返す。
	 * 
	 * @return バージョン画面
	 */
	public static VersionWindow getVersionWindow()
	{
		return versionWindow;
	}
	
	/**
	 * 処理待ちダイアログの表示状態を設定する。
	 *
	 * @param visible 表示状態
	 */
	public static void runBusyTask(BusyTask task)
	{
		if (task == null) return;
		busyDialog.setTask(task);
	}

	/**
	 * アクションマップを返す。
	 * 
	 * @return	アクションマップ
	 */
	public static ActionMap getActionMap()
	{
		return actionMap;
	}

	/**
	 * アクションマップを作成する。
	 */
	private static void createActionMap()
	{
		actionMap = new ActionMap();

		actionMap.put(ActionNames.REGISTER_DEF,     new RegisterDefinitionAction());
		actionMap.put(ActionNames.OPEN_ENGINE,      new OpenAction());
		actionMap.put(ActionNames.SHUTDOWN_ENGINE,  new ShutdownAction());
		actionMap.put(ActionNames.EXIT,             new ExitAction());

		actionMap.put(ActionNames.EXCEPTION_VIEWER, new ExceptionViewerAction());
		actionMap.put(ActionNames.PREFERENCES,      new PreferencesAction());

		actionMap.put(ActionNames.HELP,             new HelpAction());
		actionMap.put(ActionNames.ABOUT,            new VersionAction());
	}
}
