/* $Id: WorkflowAdmin.java,v 1.3 2007/12/10 09:34:42 nito Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

//import javax.swing.UIManager;

import jp.co.argo21.nautica.commons.swing.ExceptionViewer;

/**
 * Nauticaワークフロー運用管理ツール起動用のメインクラスである。
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 1.0
 */
public class WorkflowAdmin
{
	/**
	 * Nauticaワークフロー運用管理ツール本体ロード用mainメソッドである。
	 *
	 * @param	args	起動時の引数
	 */
	public static void main(String[] args)
	{
		try {
			//UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

			WorkflowAdminManager.boot();
		} catch (Exception ex) {
			WorkflowAdmin.shutdownWithException(ex);
		}
	}
	
	/**
	 * Nauticaワークフロー運用管理ツールのブート失敗処理
	 * 
	 * @param ex 任意の例外
	 */
	private static void shutdownWithException(Exception ex)
	{
		ExceptionViewer exceptionViewer = new ExceptionViewer(null, true);
		exceptionViewer.setThrowable(ex);
		exceptionViewer.setMessage(
			"Nautica WorkflowAdmin boot process failed.\n"
			+ "Please press CLOSE button for shutdown.");
		exceptionViewer.setVisible(true);
	}
}
