/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util.xml;

import java.util.HashMap;
import java.util.Map;
import org.seasar.mayaa.impl.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class TagHandler {
    protected static final AttributesImpl NULL_ATTR = new AttributesImpl();
    private static final TagHandler NULL_HANDLER = new TagHandler("_null_");
    private Map _children = new HashMap();
    private boolean _valid = true;
    private StringBuffer _buffer = new StringBuffer();
    private String _name;

    public TagHandler(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    protected void putHandler(TagHandler child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        this._children.put(child.getName(), child);
    }

    protected void start(Attributes attributes, String systemID, int lineNumber) {
    }

    protected void end(String body) {
    }

    public void invalidate() {
        this._valid = false;
    }

    public boolean isValid() {
        return this._valid;
    }

    public TagHandler startElement(String name, Attributes attributes, String systemID, int lineNumber) {
        TagHandler child;
        if (this._valid && (child = (TagHandler)this._children.get(name)) != null) {
            child._valid = true;
            child._buffer.setLength(0);
            child.start(attributes, systemID, lineNumber);
            return child;
        }
        return NULL_HANDLER;
    }

    public void endElement() {
        this.end(this._buffer.toString().trim());
    }

    public void characters(String body) {
        this._buffer.append(body);
    }
}

