/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.io.File;
import java.io.FilenameFilter;
import org.seasar.mayaa.impl.util.FileSearchIterator;
import org.seasar.mayaa.impl.util.StringUtil;

public class SystemIDFileSearchIterator
extends FileSearchIterator {
    public SystemIDFileSearchIterator(File rootDir, final String[] filters) {
        super(rootDir, new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir.getPath() + File.separatorChar + name);
                if (file.isHidden()) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                if (filters == null) {
                    return name.toLowerCase().endsWith(".html");
                }
                for (int i = 0; i < filters.length; ++i) {
                    String filter = filters[i].trim();
                    if (!(filter.matches("^\\.[a-z0-9]+") ? name.toLowerCase().endsWith(filter) : name.matches(filter))) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                if (filters != null) {
                    return "[" + StringUtil.join(filters, ",") + "]";
                }
                return null;
            }
        });
    }

    public Object next() {
        return this.makeSystemID((File)super.next());
    }

    protected String makeSystemID(File current) {
        String rootPath = this.getRoot().getPath();
        String filePath = current.getPath();
        filePath = filePath.substring(rootPath.length());
        if ((filePath = filePath.replace(File.separatorChar, '/')).length() > 0 && filePath.startsWith("/")) {
            filePath.substring(1);
        }
        return filePath;
    }
}

