/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.TemplateRenderer;
import org.seasar.mayaa.engine.processor.InformalPropertyAcceptable;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.processor.TemplateProcessor;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.PageImpl;
import org.seasar.mayaa.impl.engine.RenderNotCompletedException;
import org.seasar.mayaa.impl.engine.RenderUtil;
import org.seasar.mayaa.impl.engine.processor.DoRenderNotFoundException;
import org.seasar.mayaa.impl.engine.processor.DoRenderProcessor;
import org.seasar.mayaa.impl.engine.processor.InsertRenderingParams;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class InsertProcessor
extends TemplateProcessorSupport
implements CONST_IMPL,
InformalPropertyAcceptable,
TemplateRenderer {
    private static final long serialVersionUID = -1240398725406503403L;
    private static final String RENDERING_INSERT_CHAIN = (class$org$seasar$mayaa$impl$engine$processor$InsertProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$InsertProcessor = InsertProcessor.class$("org.seasar.mayaa.impl.engine.processor.InsertProcessor")) : class$org$seasar$mayaa$impl$engine$processor$InsertProcessor).getName() + "#renderingInsertChain";
    private static final String INSERT_PARAMS = (class$org$seasar$mayaa$impl$engine$processor$InsertProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$InsertProcessor = InsertProcessor.class$("org.seasar.mayaa.impl.engine.processor.InsertProcessor")) : class$org$seasar$mayaa$impl$engine$processor$InsertProcessor).getName() + "#insertParams";
    private String _path;
    private String _name = "";
    private String _suffix;
    private String _extension;
    private List _attributes;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$processor$InsertProcessor;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$processor$ProcessorProperty;
    static /* synthetic */ Class class$java$lang$Object;

    public void setPath(String path) {
        this._path = path;
    }

    public void setName(String name) {
        if (name != null) {
            this._name = name;
        }
    }

    public void addInformalProperty(PrefixAwareName name, Serializable attr) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(attr);
    }

    public Class getPropertyClass() {
        return class$org$seasar$mayaa$engine$processor$ProcessorProperty == null ? (class$org$seasar$mayaa$engine$processor$ProcessorProperty = InsertProcessor.class$("org.seasar.mayaa.engine.processor.ProcessorProperty")) : class$org$seasar$mayaa$engine$processor$ProcessorProperty;
    }

    public Class getExpectedClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = InsertProcessor.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public List getInformalProperties() {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        return this._attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page getPage() {
        Page result = null;
        if (StringUtil.hasValue(this._path)) {
            InsertProcessor insertProcessor = this;
            synchronized (insertProcessor) {
                Engine engine = ProviderUtil.getEngine();
                String suffixSeparator = engine.getParameter("suffixSeparator");
                String[] pagePath = StringUtil.parsePath(this._path, suffixSeparator);
                String sourcePath = EngineUtil.getSourcePath(this.getParentProcessor());
                result = engine.getPage(StringUtil.adjustRelativePath(sourcePath, pagePath[0]));
                this._suffix = pagePath[1];
                this._extension = pagePath[2];
            }
        }
        return result;
    }

    protected Stack getRenderingParams() {
        return (Stack)CycleUtil.getLocalVariable(INSERT_PARAMS, this, null);
    }

    protected InsertRenderingParams pushRenderingParams() {
        InsertRenderingParams newParams = new InsertRenderingParams();
        return this.getRenderingParams().push(newParams);
    }

    protected InsertRenderingParams peekRenderingParams() {
        return (InsertRenderingParams)this.getRenderingParams().peek();
    }

    protected InsertRenderingParams popRenderingParams() {
        Stack stack = this.getRenderingParams();
        return (InsertRenderingParams)stack.pop();
    }

    public Map getRenderingParameters() {
        InsertRenderingParams params = this.peekRenderingParams();
        if (params.isRendering()) {
            return params.getParams();
        }
        return null;
    }

    protected void invokeBeforeRenderComponent(Page component) {
        InsertRenderingParams params = this.peekRenderingParams();
        params.setRendering(true);
        params.setStackComponent(PageImpl.getCurrentComponent());
        params.setCurrentComponent(component);
        PageImpl.setCurrentComponent(component);
        SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_BEFORE_RENDER_COMPONENT);
    }

    protected void invokeAfterRenderComponent() {
        InsertRenderingParams params = this.peekRenderingParams();
        PageImpl.setCurrentComponent(params.getCurrentComponent());
        SpecificationUtil.execEvent(ProviderUtil.getEngine(), CONST_IMPL.QM_AFTER_RENDER_COMPONENT);
        PageImpl.setCurrentComponent(params.getStackComponent());
        params.setRendering(false);
        params.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStatus doStartProcess(Page topLevelPage) {
        Page renderPage = this.getPage();
        String requestedSuffix = this._suffix;
        String extension = this._extension;
        boolean fireEvent = true;
        if (renderPage == null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            renderPage = topLevelPage;
            RequestScope request = cycle.getRequestScope();
            requestedSuffix = request.getRequestedSuffix();
            extension = request.getExtension();
            fireEvent = false;
        }
        if (renderPage == null) {
            throw new IllegalStateException();
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(this.getInformalProperties().size());
        for (int i = 0; i < this.getInformalProperties().size(); ++i) {
            Object object = this.getInformalProperties().get(i);
            if (!(object instanceof ProcessorProperty)) continue;
            ProcessorProperty prop = (ProcessorProperty)object;
            properties.put(prop.getName().getQName().getLocalName(), prop.getValue().execute(null));
        }
        Map params = this.pushRenderingParams().getParams();
        params.clear();
        params.putAll(properties);
        properties.clear();
        this.invokeBeforeRenderComponent(renderPage);
        try {
            Response response;
            ProcessStatus ret;
            InsertProcessor.getRenderingInsertChain().push(this);
            try {
                ret = RenderUtil.renderPage(fireEvent, this, this.getVariables(), renderPage, requestedSuffix, extension);
            }
            finally {
                InsertProcessor.getRenderingInsertChain().pop();
            }
            if (ret == null && !(response = CycleUtil.getResponse()).getWriter().isDirty()) {
                throw new RenderNotCompletedException(renderPage.getPageName(), extension);
            }
            if (ret == ProcessStatus.EVAL_PAGE) {
                ret = ProcessStatus.SKIP_BODY;
            }
            return ret;
        }
        catch (RuntimeException e) {
            this.invokeAfterRenderComponent();
            throw e;
        }
    }

    protected static Stack getRenderingInsertChain() {
        return (Stack)CycleUtil.getGlobalVariable(RENDERING_INSERT_CHAIN, null);
    }

    public static InsertProcessor getRenderingCurrent() {
        if (InsertProcessor.getRenderingInsertChain().size() == 0) {
            return null;
        }
        return (InsertProcessor)InsertProcessor.getRenderingInsertChain().peek();
    }

    public ProcessStatus doEndProcess() {
        this.invokeAfterRenderComponent();
        this.popRenderingParams();
        return super.doEndProcess();
    }

    protected DoRenderProcessor findDoRender(ProcessorTreeWalker proc, String name) {
        DoRenderProcessor doRender = null;
        for (int i = 0; i < proc.getChildProcessorSize(); ++i) {
            ProcessorTreeWalker child = proc.getChildProcessor(i);
            if (child instanceof DoRenderProcessor) {
                doRender = (DoRenderProcessor)child;
                if (StringUtil.isEmpty(name) || name.equals(doRender.getName())) break;
            }
            if ((doRender = this.findDoRender(child, name)) != null) break;
        }
        return doRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DoRenderProcessor findDoRender(Template[] templates, String name) {
        Engine engine = ProviderUtil.getEngine();
        synchronized (engine) {
            for (int i = templates.length - 1; 0 <= i; --i) {
                DoRenderProcessor doRender = this.findDoRender(templates[i], name);
                if (doRender == null) continue;
                return doRender;
            }
        }
        return null;
    }

    protected TemplateProcessor getRenderRoot(DoRenderProcessor doRender) {
        if (!doRender.isReplace()) {
            ProcessorTreeWalker duplecated = doRender.getParentProcessor();
            if (duplecated == null || !(duplecated instanceof TemplateProcessor)) {
                throw new IllegalStateException();
            }
            return (TemplateProcessor)duplecated;
        }
        return doRender;
    }

    public ProcessStatus renderTemplate(Page topLevelPage, Template[] templates) {
        if (topLevelPage == null || templates == null || templates.length == 0) {
            throw new IllegalArgumentException();
        }
        DoRenderProcessor doRender = this.findDoRender(templates, this._name);
        if (doRender == null) {
            throw new DoRenderNotFoundException(this._name);
        }
        TemplateProcessor insertRoot = this.getRenderRoot(doRender);
        doRender.pushInsertProcessor(this);
        ProcessStatus ret = RenderUtil.renderTemplateProcessor(topLevelPage, insertRoot);
        doRender.popInsertProcessor();
        return ret;
    }

    public void kill() {
        if (this._attributes != null) {
            this._attributes.clear();
        }
        super.kill();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CycleUtil.registVariableFactory(RENDERING_INSERT_CHAIN, new DefaultCycleLocalInstantiator(){

            public Object create(Object[] params) {
                return new Stack();
            }
        });
        CycleUtil.registVariableFactory(INSERT_PARAMS, new DefaultCycleLocalInstantiator(){

            public Object create(Object owner, Object[] params) {
                return new Stack();
            }
        });
    }
}

