/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.util.DateFormatPool;
import org.seasar.mayaa.impl.util.StringUtil;

public class FormatDateProcessor
extends TemplateProcessorSupport {
    private static final long serialVersionUID = -3881431416799800307L;
    private ProcessorProperty _value;
    private ProcessorProperty _default;
    private String _pattern;

    public void initialize() {
        if (this._pattern == null) {
            this._pattern = new SimpleDateFormat().toPattern();
        }
    }

    public void setValue(ProcessorProperty value) {
        this._value = value;
    }

    public void setDefault(ProcessorProperty defaultValue) {
        this._default = defaultValue;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._value != null) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            cycle.getResponse().write(this.format(this._value));
        }
        return ProcessStatus.SKIP_BODY;
    }

    private String format(ProcessorProperty property) {
        Object result = property.getValue().execute(null);
        if (StringUtil.hasValue(result)) {
            if (result instanceof Date) {
                DateFormat formatter = DateFormatPool.borrowFormat(this._pattern);
                String formattedValue = formatter.format(result);
                DateFormatPool.returnFormat(formatter);
                return formattedValue;
            }
            throw new IllegalArgumentException("argument type mismatch: " + result.getClass().getName());
        }
        if (this._default != null) {
            return (String)this._default.getValue().execute(null);
        }
        return "";
    }

    public void kill() {
        this._value = null;
        this._default = null;
        super.kill();
    }
}

