/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Stack;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.IterationProcessor;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.IteratorUtil;

public class ForEachProcessor
extends TemplateProcessorSupport
implements IterationProcessor {
    private static final long serialVersionUID = -1762792311844341560L;
    private static final String PROCESS_TIME_INFO_KEY = (class$org$seasar$mayaa$impl$engine$processor$ForEachProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$ForEachProcessor = ForEachProcessor.class$("org.seasar.mayaa.impl.engine.processor.ForEachProcessor")) : class$org$seasar$mayaa$impl$engine$processor$ForEachProcessor).getName() + "#processTimeInfo";
    private String _var;
    protected ProcessorProperty _items;
    protected String _indexName;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$processor$ForEachProcessor;

    public void setVar(String var) {
        this._var = var;
    }

    public void setItems(ProcessorProperty items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        this._items = items;
    }

    public void setIndexName(String indexName) {
        this._indexName = indexName;
    }

    public boolean isIteration() {
        return true;
    }

    protected boolean prepareEvalBody() {
        IndexIteratorStack stack = (IndexIteratorStack)CycleUtil.getLocalVariable(PROCESS_TIME_INFO_KEY, this, null);
        IndexedIterator iterator = stack.peek();
        if (!iterator.hasNext()) {
            return false;
        }
        CycleUtil.setAttribute(this._var, iterator.next(), null);
        if (this._indexName != null) {
            CycleUtil.setAttribute(this._indexName, iterator.getNextIndex(), "page");
        }
        return true;
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        if (this._items == null || this._var == null) {
            throw new IllegalStateException();
        }
        IndexIteratorStack stack = (IndexIteratorStack)CycleUtil.getLocalVariable(PROCESS_TIME_INFO_KEY, this, null);
        stack.pushOne();
        if (!this.prepareEvalBody()) {
            stack.pop();
            return ProcessStatus.SKIP_BODY;
        }
        return ProcessStatus.EVAL_BODY_INCLUDE;
    }

    public ProcessStatus doAfterChildProcess() {
        if (!this.prepareEvalBody()) {
            IndexIteratorStack stack = (IndexIteratorStack)CycleUtil.getLocalVariable(PROCESS_TIME_INFO_KEY, this, null);
            stack.pop();
            return ProcessStatus.SKIP_BODY;
        }
        return ProcessStatus.EVAL_BODY_AGAIN;
    }

    public void kill() {
        this._items = null;
        super.kill();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CycleUtil.registVariableFactory(PROCESS_TIME_INFO_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object owner, Object[] params) {
                ForEachProcessor processor = (ForEachProcessor)owner;
                return processor.new IndexIteratorStack();
            }
        });
    }

    private class IndexedIterator {
        private int _index;
        private Iterator _iterator;

        public IndexedIterator() {
            if (ForEachProcessor.this._indexName != null) {
                this._index = -1;
            }
            Object obj = ProviderUtil.getScriptEnvironment().convertFromScriptObject(ForEachProcessor.this._items.getValue().execute(null));
            this._iterator = IteratorUtil.toIterator(obj);
        }

        public Integer getNextIndex() {
            return new Integer(++this._index);
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() {
            return this._iterator.next();
        }
    }

    private class IndexIteratorStack {
        private Stack _stack = new Stack();

        public void pushOne() {
            this._stack.push(new IndexedIterator());
        }

        public IndexedIterator pop() {
            return (IndexedIterator)this._stack.pop();
        }

        public IndexedIterator peek() {
            return (IndexedIterator)this._stack.peek();
        }
    }
}

